import {useContext} from "react";
import {Root} from "../../dataCenter/Root";
import {useFormState} from "../../utils/hook";
import PopContainer from "../PopContainer/PopContainer";
import './Pop_addType.scss'

function Pop_addType(props) {

    const {fetchData, updateIndex} = useContext(Root)

    const [input, setInput] = useFormState()

    const addType = () => {
        fetchData('/add/addType', input)
            .then(() => updateIndex())
    }

    return (
        <PopContainer>
            <h2 className='Pop-title'>新建类型</h2>
            <div className="formArea">
                <div className="input-group ">
                    <input type="text" onChange={e => setInput('type_name', e.target.value)}
                           defaultValue={input?.type_name}
                           min={1} required/>
                    <span> 类型名称</span>
                </div>
            </div>
            <div className="Pop-bottom">
                <button className='btn-submit-addToolBox' onClick={() => addType()}>提交</button>
            </div>
        </PopContainer>
    )
}

export default Pop_addType
