import './Pop_addToolBox.scss'
import {useContext} from "react";
import {Root} from "../../dataCenter/Root";
import {useFormState} from "../../utils/hook";
import PopContainer from "../PopContainer/PopContainer";

function Pop_addToolBox() {
    const {fetchData, updateIndex, dataCenter} = useContext(Root)
    const [input, setInput] = useFormState()

    const addToolBox = () => {
        fetchData('/add/addToolBox', input)
            .then(() => updateIndex())
    }

    return (
        <PopContainer>
            <h2 className='Pop-title'>新建工具盒</h2>
            <div className="formArea">
                <div className="input-group ">
                    <input type="text" onChange={e => setInput('toolbox_name', e.target.value)}
                           defaultValue={input?.['toolbox_name']}
                           min={1} required/>
                    <span> 名称</span>
                </div>
                <div className="input-group ">
                    <input type="text" onChange={e => setInput('toolbox_icon', e.target.value)}
                           defaultValue={input?.['toolbox_icon']}
                           min={1} required/>
                    <span> 图标</span>
                </div>
                <div className="input-group ">
                    <input type="text" onChange={e => setInput('toolbox_desc', e.target.value)}
                           defaultValue={input?.['toolbox_desc']}
                           min={1} required/>
                    <span> 描述</span>
                </div>
                <div className="input-group ">
                    <input type="text" onChange={e => setInput('toolbox_url', e.target.value)}
                           defaultValue={input?.['toolbox_url']} min={1}
                           required/>
                    <span> 链接</span>
                </div>
                <div className="input-group ">
                    <select onChange={(e)=> setInput('type_id',e.target.value)}>
                        {
                            dataCenter?.type?.length && dataCenter?.type.map(v=>{
                                return (
                                    <option key={v.type_id} value={v.type_id}>{v.type_name}</option>
                                )
                            })
                        }

                    </select>
                    <span> 类型</span>
                </div>
            </div>
            <div className="Pop-bottom">
                <button className='btn-submit-addToolBox' onClick={() => addToolBox()}>提交</button>
            </div>
        </PopContainer>
    )
}

export default Pop_addToolBox
