import {useContext} from "react";
import {Root} from "../../dataCenter/Root";
import {useFormState} from "../../utils/hook";
import PopContainer from "../PopContainer/PopContainer";

function Pop_toolBoxConfig(props) {
    const {toolbox_name, toolbox_icon, toolbox_desc, toolbox_url, toolbox_id} = props.value
    const {fetchData, updateIndex} = useContext(Root)
    const [input, setInput] = useFormState({
        toolbox_name,
        toolbox_icon,
        toolbox_desc,
        toolbox_url
    })

    const updateToolBox = () => {
        fetchData('/update/updateToolBox', Object.assign({}, input, {toolbox_id}))
            .then(() => updateIndex())
    }


    return (
        <PopContainer>
            <h2 className='Pop-title'>{toolbox_name}</h2>
            <div className="formArea">
                <div className="input-group ">
                    <input type="text" onChange={e => setInput('toolbox_name', e.target.value)}
                           defaultValue={input?.['toolbox_name']}
                           min={1} required/>
                    <span> 名称</span>
                </div>
                <div className="input-group ">
                    <input type="text" onChange={e => setInput('toolbox_icon', e.target.value)}
                           defaultValue={input?.['toolbox_icon']}
                           min={1} required/>
                    <span> 图标</span>
                </div>
                <div className="input-group ">
                    <input type="text" onChange={e => setInput('toolbox_desc', e.target.value)}
                           defaultValue={input?.['toolbox_desc']}
                           min={1} required/>
                    <span> 描述</span>
                </div>
                <div className="input-group ">
                    <input type="text" onChange={e => setInput('toolbox_url', e.target.value)}
                           defaultValue={input?.['toolbox_url']} min={1}
                           required/>
                    <span> 链接</span>
                </div>
            </div>
            <div className="Pop-bottom">
                <button className='btn-submit-addToolBox'
                        onClick={() => updateToolBox()}>提交
                </button>
            </div>
        </PopContainer>

    )
}

export default Pop_toolBoxConfig
