import './ContentItem.scss'
import notFollow from '../../static/notFollow.png'
import followed from '../../static/followed.png'
import setting from '../../static/setting.svg'
import trash from '../../static/trash.svg'
import dragIcon from '../../static/dragIcon.svg'
import {useContext, useState} from "react";
import {PopContext, Root} from "../../dataCenter/Root";
import ToolModal from "../../modal/ToolModal"

function ContentItemAdmin(props) {
    const [visible, setVisible] = useState(false)

    const {fetchData} = useContext(Root)
    const {showPop} = useContext(PopContext)

    const {toolbox_icon, toolbox_name, toolbox_desc, toolbox_url, follow, toolbox_id} = props.value

    const [itemIcon, setItemIcon] = useState(toolbox_icon)

    const jumpUrl = url => {
        window.location.href = url
    }
    const deleteItem = toolbox_id => {
        fetchData('/delete/deleteToolBoxById', {toolbox_id})
    }

    return (
        <div className="content-item">
            <div className="content-adminTool">
                <img src={dragIcon} alt=""/>
                <img src={setting} alt="" onClick={() => setVisible(true)}/>
                <img src={trash} alt="" onClick={() => deleteItem(toolbox_id)}/>
            </div>
            <div className="item-icon" onClick={() => jumpUrl(toolbox_url)}>
                {
                    !itemIcon && <div className="defaultIcon">{toolbox_name[0]}</div>
                }
                {
                    itemIcon && <img src={itemIcon} alt='' onError={e => setItemIcon(null)}/>
                }
            </div>
            <div className="item-name" onClick={() => jumpUrl(toolbox_url)}>{toolbox_name}</div>
            <div className="item-desc">{toolbox_desc}</div>
            <a className='item-url' href={toolbox_url}>{toolbox_url}</a>
            <div className="follow">
                <img className='icon-follow' src={follow ? followed : notFollow} alt=""/>
                收藏
            </div>
            {visible && <ToolModal
                visible={visible}
                onCancel={() =>
                    setVisible(false)
                }
                data={props.value}
            />}
        </div>

    )
}

export default ContentItemAdmin
