import React, { useState, useEffect, useContext } from 'react';
import { Root } from "../dataCenter/Root";
import { Button, Modal, Form, Input, Radio, Select, message } from 'antd';
import { NEED_UPDATE_INDEX } from "../dataCenter/action";
const { Option } = Select;
const ToolModal = ({ visible, onCancel, data }) => {
    const [form] = Form.useForm();
    const { fetchData, dataCenter, dispatch } = useContext(Root)
    const formItemLayout = {
        labelCol: { span: 4 },
        wrapperCol: { span: 18 },
    };
    const onCreate = (values) => {
        let input = {
            toolbox_name: values.name,
            toolbox_icon: values.icon,
            toolbox_desc: values.depict,
            toolbox_url: values.url,

        }
        if (!data) {
            input = {
                ...input,
                type_id: values.type,
                child_type_id: values.childType
            }
            console.log(input);
            fetchData('/add/addToolBox', input)
                .then((res) => {
                    if (res.success) {
                        message.success('新建成功')
                        dispatch(NEED_UPDATE_INDEX())
                        onCancel()
                    } else {
                        message.error('新建失败')
                    }
                })

        } else {
            fetchData('/update/updateToolBox', input)
                .then((res) => {
                    if (res.success) {
                        message.success('修改成功')
                        dispatch(NEED_UPDATE_INDEX())
                        onCancel()
                    } else {
                        message.error('新建失败')
                    }
                })
        }
    };

    const onGenderChange = (value) => {
        form.setFieldsValue({
            type: value,
        });
        fetchData('/query/queryChildType', { type_id: value }, 'childType')
            .then((res) => {

                console.log(res);
            })
        console.log(dataCenter);
    };
    const onChildGenderChange = (value) => {
        form.setFieldsValue({
            childType: value,
        });
    };

    useEffect(() => {
        dataCenter?.type && fetchData('/query/queryChildType', { type_id: dataCenter?.type[0]?.type_id }, 'childType')
            .then((res) => {

                console.log(res);
            })
    }, [])

    return (
        <Modal
            visible={visible}
            title={data ? '修改工具箱' : '新建工具箱'}
            okText="确定"
            cancelText="取消"
            onCancel={onCancel}
            onOk={() => {
                form
                    .validateFields()
                    .then((values) => {
                        // form.resetFields();
                        onCreate(values);
                    })
                    .catch((info) => {
                        console.log('Validate Failed:', info);
                    });
            }}
        >
            <Form
                form={form}
                // layout="vertical"
                {...formItemLayout}
                name="form_in_modal"
                initialValues={data ? {
                    name: data.toolbox_name,
                    icon: data.toolbox_icon,
                    url: data.toolbox_url,
                    depict: data.toolbox_desc,
                } : { type: dataCenter?.type && dataCenter?.type[0]?.type_id }}
            >
                <Form.Item
                    name="name"
                    label="名称"
                    rules={[
                        {
                            required: true,
                            message: '请输入名称!',
                        },
                    ]}
                >
                    <Input placeholder="请输入名称" />
                </Form.Item>
                <Form.Item name="icon"
                    label="图标"
                    rules={[
                        {
                            required: true,
                            message: '请输入图标url!',
                        },
                    ]}
                >
                    <Input placeholder="请输入图标url" />
                </Form.Item>
                <Form.Item
                    name="depict"
                    label="描述"
                    rules={[
                        {
                            required: true,
                            message: '请输入描述!',
                        },
                    ]}
                >
                    <Input placeholder="请输入描述" />
                </Form.Item>
                <Form.Item
                    name="url"
                    label="链接"
                    rules={[
                        {
                            required: true,
                            message: '请输入链接!',
                        },
                    ]}
                >
                    <Input placeholder="请输入链接" />
                </Form.Item>
                {!data && <Form.Item
                    name="type"
                    label="类型"
                    rules={[
                        {
                            required: true,
                            message: '请选择类型!',
                        },
                    ]}
                >
                    <Select
                        placeholder="请选择类型"
                        onChange={onGenderChange}
                    // allowClear
                    >
                        {
                            dataCenter?.type?.length && dataCenter?.type.map(v => {
                                return (
                                    <Option key={v.type_id} value={v.type_id}>{v.type_name}</Option>
                                )
                            })
                        }

                    </Select>
                </Form.Item>}
                {!data && dataCenter?.childType && <Form.Item
                    name="childType"
                    label="子类型"
                >
                    <Select
                        placeholder="请选择子类型"
                        onChange={onChildGenderChange}
                        allowClear
                    >
                        {
                            dataCenter?.childType?.length && dataCenter?.childType.map(v => {
                                return (
                                    <Option key={v.child_type_id} value={v.child_type_id}>{v.child_type_name}</Option>
                                )
                            })
                        }

                    </Select>
                </Form.Item>}
            </Form>
        </Modal>
    );
};
export default ToolModal
