import './PublishModal.scss'
import React, {useContext, useEffect, useState} from 'react';
import {Root} from "../dataCenter/Root";
import {UnControlled as CodeMirror} from 'react-codemirror2'
import {Form, Input, message, Modal, Select} from 'antd';
import apiConfig from "../config/apiConfig";

import 'codemirror/addon/display/autorefresh';
import 'codemirror/addon/comment/comment';
import 'codemirror/addon/edit/matchbrackets';
import 'codemirror/keymap/sublime';
import 'codemirror/theme/eclipse.css';
import 'codemirror/theme/monokai.css';
import 'codemirror/lib/codemirror.js';
import 'codemirror/lib/codemirror.css';
import 'codemirror/theme/solarized.css'
import 'codemirror/mode/javascript/javascript'
import 'codemirror/addon/selection/active-line';
import 'codemirror/addon/fold/foldgutter.css';

const { Option } = Select;


const PublishModal = ({ visible, onCancel, data }) => {
    const [code, setcode] = useState('')
    const [page_name, setPageName] = useState('')
    const [oldCode, setoldCode] = useState('')
    const { fetchData, dataCenter } = useContext(Root)
    console.log(data);
    const onCreate = (values) => {
        console.log(code);

        if (!code || !page_name) {
            message.error('请补全信息！')
            return
        }
        if (data) {
            fetch(`${apiConfig.domain}/page/updatePage`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    page_id: data.page_id,
                    page_name: page_name,
                    code: code
                })
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        onCancel()
                        message.success('替换成功！')
                        dataCenter?.type && fetchData('/page/queryPage', {}, 'queryPage')
                        .then((res) => {
                            
                        })
                    } else {
                        message.error( '替换失败')
                    }
                });
        } else {
            fetch(`${apiConfig.domain}/page/addPage`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    page_name: page_name,
                    code: code
                })
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        onCancel()
                        message.success('发布成功！')
                        dataCenter?.type && fetchData('/page/queryPage', {}, 'queryPage')
                        .then((res) => {
                            
                        })
                    } else {
                        message.error(data.error || '发布失败')
                    }
                });
        }
    };

    useEffect(() => {
       data&&setPageName(data.page_name)
    }, [data])

    return (
        <Modal
            visible={visible}
            title="发布"
            okText="发布"
            cancelText="取消"
            onCancel={onCancel}
            onOk={onCreate}
            width='1000px'
        >
            <Form.Item
                name="page_name"
                label="页面名称"
                rules={[
                    {
                        required: true,
                        message: '请输入页面名称!',
                    },
                ]}
            >
                <Input placeholder="请输入页面名称" defaultValue={data?.page_name ? data.page_name : page_name} onChange={(e) => { setPageName(e.target.value) }} />
            </Form.Item>
            <Form.Item
                name="type"
                label="布局代码"
                rules={[
                    {
                        required: true,
                        message: '请输入页面名称!',
                    },
                ]}
            >
                <div className='codeMain'>
                    <CodeMirror
                        onChange={(editor, data, value) => {
                            setcode(value)
                        }}
                        value={oldCode}
                        options={{
                            styleActiveLine: true,//光标代码高亮
                            lineNumbers: true,
                            theme: 'monokai',
                            tabSize: 2,
                            keyMap: 'sublime',
                            mode: 'text/javascript',
                            smartIndent: true,  //自动缩进
                            lineWrapping: true,
                            autofocus: true
                        }}
                    />
                </div>
            </Form.Item>
        </Modal>
    );
};
export default PublishModal
