import './ToolType.scss'
import {useContext} from "react";
import {Root} from "../../dataCenter/Root";
import {CHANGE_CHILD_TYPE, CHANGE_TYPE} from "../../dataCenter/action";

const ChildTypeItem = props => {
    const {dataCenter, dispatch} = useContext(Root)
    const {child_type_id, child_type_name} = props
    const classNameArr = ['child-type-item']
    if (child_type_id === dataCenter.child_type_id) {
        classNameArr.push('child-type-item-selected')
    }
    const handleClick = () => {
        console.log(child_type_id)
        dispatch(CHANGE_CHILD_TYPE(child_type_id))
    }
    return (
        <div className={classNameArr.join(' ')} onClick={handleClick}>{child_type_name}</div>
    )
}


function ToolType(props) {
    const {dataCenter, dispatch} = useContext(Root)
    return (
        <>
            <div className="tab-tool-type">
                <div className={dataCenter.type_id === 'follow' ? 'item-tool-type item-tool-type-selected' : 'item-tool-type'}
                     onClick={() => dispatch(CHANGE_TYPE('follow'))}>我的收藏
                </div>
                {
                    dataCenter?.type?.length > 0 && dataCenter.type.map(v => {
                        const classNameArr = ['item-tool-type ']
                        if (v["type_id"] === dataCenter.type_id) classNameArr.push('item-tool-type-selected')
                        return (
                            <div key={v["type_id"]} className={classNameArr.join('')}
                                 onClick={() => dispatch(CHANGE_TYPE( v["type_id"]))}>{v.type_name}</div>
                        )
                    })
                }
            </div>
            <div className="child-type">
                <ChildTypeItem key={'all'} child_type_id={'all'} child_type_name={'全部'}/>
                {
                    dataCenter?.childType?.length > 0 && dataCenter?.childType.map(v => {
                        return (
                            <ChildTypeItem key={v.child_type_id} child_type_id={v.child_type_id}
                                           child_type_name={v.child_type_name}/>
                        )
                    })
                }
            </div>
        </>
    )
}

export default ToolType
