import './Content.scss'
import ContentItemAdmin from "./ContentItemAdmin";
import {useContext} from "react";
import {Root} from "../../dataCenter/Root";
import ContentItem from "../Content/ContentItem";

function Content(props) {
    const {dataCenter} = useContext(Root)

    return (
        <div className="content">
            {
                dataCenter.toolBox?.length ? dataCenter?.toolBox?.filter(v => {
                        if (dataCenter.child_type_id === 'all') return true
                        else return v.child_type_id === dataCenter.child_type_id
                    }).map(v => {
                        return (
                            <ContentItemAdmin key={v['toolbox_id']} value={v}/>
                        )
                    })
                    :
                    '没有数据了！'
            }
        </div>
    )
}

export default Content
