import React, {useState} from 'react'
import './AdminIndex.scss'
import {Button} from 'antd';
import ToolModal from '../../modal/ToolModal'
import PublishModal from '../../modal/PublishModal'
import TypeModal from '../../modal/TypeModal'
import PageModal from '../../modal/PageModal'
import RemoveType from '../../modal/RemoveType'

function AdminIndex() {
    const [visible, setVisible] = useState(false)
    const [publish, setPublish] = useState(false)
    const [typeModal, setTypeModal] = useState(false)
    const [pageModal, setpageModal] = useState(false)
    const [removeType, setremoveType] = useState(false)

    return (
        <div className='admin'>
            <Button onClick={() => setVisible(true)}>新建工具盒</Button>
            <Button onClick={() => setTypeModal(true)}>新建类型</Button>
            <Button onClick={() => setPublish(true)}>发布</Button>
            <Button onClick={() => setpageModal(true)}>页面管理</Button>
            <Button onClick={() => setremoveType(true)}>类型管理</Button>
            {visible && <ToolModal
                visible={visible}
                onCancel={() =>
                    setVisible(false)
                }
            />}
            {publish && <PublishModal
                visible={publish}
                onCancel={() =>
                    setPublish(false)
                }
            />}
            {typeModal && <TypeModal
                visible={typeModal}
                onCancel={() =>
                    setTypeModal(false)
                }
            />}
            {pageModal && <PageModal
                visible={pageModal}
                onCancel={() =>
                    setpageModal(false)
                }
            />}
            {removeType && <RemoveType
                visible={removeType}
                onCancel={() =>
                    setremoveType(false)
                }
            />}
        </div>
    )
}

export default AdminIndex
