const express = require('express')
const request = require("request");
const Mysql = require('../SQLPool')
const router = express.Router()

router.get('/queryType', (req, res) => {
    const SQL = 'SELECT * FROM type'
    Mysql.query(SQL, (err, result) => {
        if (err) {
            res.send({
                success: false,
                err
            })
            return
        }
        res.send({
            success: true,
            data: result
        })
    })
})

router.get('/queryChildType', (req, res) => {
    const SQL = 'SELECT * FROM child_type'
    Mysql.query(SQL, (err, result) => {
        if (err) {
            res.send({
                success: false,
                err
            })
            return
        }
        res.send({
            success: true,
            data: result
        })
    })
})

router.get('/queryTypeForManage', (req, res) => {
    const SQL = 'SELECT child_type.child_type_id, child_type.child_type_name, child_type.type_id, type.type_name FROM child_type INNER JOIN type ON child_type.type_id = type.type_id'
    Mysql.query(SQL, [], (err, result) => {
        const dataArr = []
        const combineType = (value) => {
            if (dataArr.filter(v => v.type_id === value.type_id).length) return
            const childType = result.filter(v => v.type_id === value.type_id).map(v => ({
                child_type_id: v.child_type_id,
                child_type_name: v.child_type_name
            }))
            dataArr.push({
                type_id: value.type_id,
                type_name: value.type_name,
                children: childType
            })
        }
        result.forEach(v => {
            combineType(v)
        })

        res.send({
            success: true,
            data: dataArr
        })
    })
})

router.get('/deleteChildType', ((req, res) => {
    const {child_type_id} = req.query

    let SQL = 'DELETE FROM child_type WHERE child_type_id = ?;'
    let SQL2 = 'DELETE FROM type_childtype_toolbox WHERE child_type_id = ?;'

    Mysql.query(SQL, [child_type_id], (err, result) => {
        if (err) {
            res.send({
                success: false,
                err
            })
            return
        }
        Mysql.query(SQL2, [child_type_id], (err, result) => {
            res.send({
                success: true,
            })
        })

    })
}))

router.get('/updateType', (req, res) => {
    const {type_id, type_name, child_type_id, child_type_name} = req.query
    let SQL
    const values = []
    if (type_id) {
        SQL = 'UPDATE type SET type_name = ? WHERE type_id = ?'
        values.push(type_name)
        values.push(type_id)
    } else {
        SQL = 'UPDATE child_type SET child_type_name = ? WHERE child_type_id = ?'
        values.push(child_type_name)
        values.push(child_type_id)
    }
    Mysql.query(SQL, values, (err, result) => {
        if (err) {
            res.send({
                success: false,
                err
            })
            return
        }
        res.send({
            success: true,
        })
    })
})

module.exports = router
