const express = require('express');
const Mysql = require('../SQLPool')
const fs = require("fs");
const request = require("request");
const path = require("path");
const router = express.Router();


router.post('/addPage', (req, res) => {
    const {page_name, code} = req.body

    const SQL = `INSERT INTO page (page_name) VALUES (?)`

    Mysql.query(SQL, [page_name], (err, result) => {
        if (err) {
            res.send({
                success: false,
                error: err
            })
        } else {
            const a = [{
                typeId: 1,
            }]
            try {
                request(domain + '/page/queryPage', {}, (a, b, body) => {
                    const data = JSON.parse(body).data
                    const id = data[data.length - 1]['page_id']
                    const fileName = 'page' + id + '.html'
                    try {
                        console.log('path:', path.join(__dirname, '../static/' + fileName))
                        fs.writeFileSync(path.join(__dirname, '../static/' + fileName), code)
                        res.send({
                            success: true
                        })
                    } catch (e) {
                        res.send({
                            success: false,
                            error: e
                        })
                        console.error(e)
                    }
                })
            } catch (e) {
                console.error(e)
                res.send({
                    success: false,
                    error: e
                })
            }
        }
    })
})


router.get('/queryPage', (req, res) => {
    const SQL = 'SELECT * FROM page'
    Mysql.query(SQL, [], (err, result) => {
        if (err) {
            res.send({
                success: false,
                err
            })
        }

        const _result = result.map(v => {
            const url = 'http://172.16.130.180:3001/static/' + 'page' + v['page_id'] + '.html'
            return {
                ...v,
                pageUrl: url
            }
        })

        res.send({
            success: true,
            data: _result
        })
    })
})

router.post('/updatePage', (req, res) => {
    const {page_id, page_name, code} = req.body
    const SQL = 'UPDATE page SET page_name=?  WHERE page_id = ?'
    Mysql.query(SQL, [page_name, page_id], (err, result) => {
        if (err) {
            res.send({
                success: false,
                error: err
            })
        } else {
            try{
                const fileName = 'page' + page_id + '.html'
                fs.writeFileSync(path.join(__dirname, '../static/' + fileName), code)
                res.send({
                    success: true
                })
            }catch (e){
                res.send({
                    success: false,
                    error: e
                })
            }

        }
    })
})

module.exports = router
