const express = require('express');
const path = require('path');
const cookieParser = require('cookie-parser');
const logger = require('morgan');
const bodyParser = require('body-parser')

const indexRouter = require('./routes');
const usersRouter = require('./routes/users');
const queryRouter = require('./routes/query')
const addRouter = require('./routes/add')
const deleteRouter = require('./routes/delete')
const updateRouter = require('./routes/update')
const submitRouter = require('./routes/page')
const typeManage = require('./routes/typeManage')
const engines = require('consolidate')

const app = express();
global.domain = 'http://10.104.83.91:3000/'
// global.domain = 'http://127.0.0.1:3001'

const Eureka = require('eureka-node').default
const DockerApp = require('docker-app-node')

const pkg = require('./package.json')



// 获取配置的端口号
const port = 3000

const dockerApp = new DockerApp({
    app,
    appType: 'express',
    port
})

// 注册Eureka
global.eureka = new Eureka({
    port, // 应用端口号
    appName: pkg.name, // 应用名称
    services: ['KJY-WEB'] // 依赖服务名
})

global.eureka.start().then(() => {
    dockerApp.startServer()
})


//
// app.use((req, res, next) => {
//     const url = req.url
//
//     const header = {
//         'Access-Control-Allow-Credentials': true,
//         'Access-Control-Allow-Origin': req.headers.origin || '*',
//         'Access-Control-Allow-Headers': 'X-Requested-With,Content-Type',
//         'Access-Control-Allow-Methods': 'PUT,POST,GET,DEconstE,OPTIONS',
//         'Content-Type': 'application/json; charset=utf-8'
//     }
//
//     if (url.includes('static')){
//         header["Content-Type"] = 'text/html; charset=utf-8'
//     }
//     //设置相应头
//     res.set(header)
//     req.method === 'OPTIONS' ? res.status(204).end() : next()
// })



app.use(bodyParser.urlencoded({extended: false}))
app.use(bodyParser.json())
app.use(logger('dev'));
app.use(express.json());
app.use(express.urlencoded({extended: false}));
app.use(cookieParser());
app.engine('html', engines.mustache)
app.set('view engine', 'html')
app.set('views', path.join(__dirname, '/staticFile/build'));
// app.use(favicon(path.join(__dirname, "../static/build/favicon.ico")));
// app.use('/scripts', express.static(path.join(__dirname, 'node_modules')));
// app.use(express.static(path.join(__dirname, 'build')));
app.get('/', function(req, res){
    res.type('html')
    res.render('index.html');
});
app.use('/staticFile', express.static(path.join(__dirname, 'staticFile')));
app.use('/static',express.static(path.join(__dirname, 'staticFile/build/static')))

// app.use('/', indexRouter);
app.use('/users', usersRouter);
app.use('/query', queryRouter)
app.use('/add', addRouter)
app.use('/delete', deleteRouter)
app.use('/update', updateRouter)
app.use('/page', submitRouter)
app.use('/typeManage', typeManage)


module.exports = app;
