import logo from "../../static/logo.png";
import './index.scss'
import {PopContext, Root} from "../../dataCenter/Root";
import {useContext, useEffect} from "react";
import {NEED_UPDATE_INDEX} from "../../dataCenter/action";
import AdminIndex from "../../component/AdminIndex/AdminIndex";
import {useHistory} from "react-router-dom";
import gotoLogin from "../../utils/gotoLogin";
import IndexContentAdmin from "../../component/IndexContent/IndexContentAdmin";

function Index() {
    const history = useHistory()
    const {fetchData, dataCenter, dispatch} = useContext(Root)
    const showPop = popComponent => {
    }
    const getUser = () => {
        fetchData('/users/getUser', {}, 'userInfo')
            .then(res => {
                if (+res?.data?.admin !== 1) {
                    history.push('/')
                }
            })
            .catch(res =>
                +res.code === 70001 && (gotoLogin())
            )
    }

    // useEffect(() => {
    //     fetchData('/typeManage/queryTypeForManage', {}, 'type')
    //         // .then(()=> fetchData('/query/queryChildType',{type_id: dataCenter.type_id},'childType'))
    //         .then(() => dispatch(NEED_UPDATE_INDEX()))
    // }, [dataCenter.type_id])

    useEffect(() => {
        if (dataCenter.needUpdateIndex) {
            fetchData('/query/queryToolBox', {}, 'toolBox')
                .then(() => fetchData('/typeManage/queryTypeForManage', {}, 'type'))
                .then(() => dispatch(NEED_UPDATE_INDEX()))
        }
    }, [dataCenter.needUpdateIndex])

    useEffect(async () => {
        await getUser()
        dispatch(NEED_UPDATE_INDEX())
    }, [])

    return (
        <PopContext.Provider value={{hidePop: () => setPop(''), showPop: popName => showPop(popName)}}>
            <div className="index-admin">
                <div className="welcome-top">
                    <span>欢迎您！
                        <span className="welcome-uname">{dataCenter?.userInfo?.name}</span>
                        <a className="login-btn">退出登录</a>
                    </span>
                </div>
                <div className="nav">
                    <div className="nav-title">
                        <img src={logo} alt=""/>
                    </div>
                    <div className="nav-weather">
                        <iframe width="360" height="40" frameBorder="0" scrolling="no" hspace="0"
                                src="https://i.tianqi.com/?c=code&a=getcode&id=40&icon=1"/>
                    </div>
                </div>
                <IndexContentAdmin typeData={[{type_id: 'follow', type_name: '我的收藏'}]}/>
                {
                    Array.isArray(dataCenter?.type) && dataCenter?.type?.map(v => (
                        <div key={v.type_id}>
                            <IndexContentAdmin typeData={[v]}/>
                        </div>
                    ))
                }
                <div className="index-footer">
                    兑吧研发中心·杭州兑吧网络科技游戏公司版权所有
                    <br/>
                    浙ICP备14017299号-1
                </div>
                <AdminIndex/>
            </div>
        </PopContext.Provider>
    )
}

export default Index

