import logo from "../../static/logo.png";
import './index.scss'
import {Root} from "../../dataCenter/Root";
import React, {useContext, useEffect, useState} from "react";
import {NEED_UPDATE_INDEX, UPDATE_DATA} from "../../dataCenter/action";
import {useHistory} from "react-router-dom";
import gotoLogin from "../../utils/gotoLogin";
import IndexContent from "../../component/IndexContent/IndexContent";
import sendMd, {Exposure} from "../../utils/sendMd";
import TypeNavBar from "../../component/TypeNavBar/TypeNavBar";

function Index() {
    const history = useHistory()
    const [mdLock, setMdLock] = useState(false)
    const {fetchData, dataCenter, dispatch} = useContext(Root)

    const getUser = async () => {
        await fetchData('/users/getUser', {}, 'userInfo')
            .then(res => {
                if (!res.success && res.code === 70001) {
                    gotoLogin()
                }
                return res
            })
    }


    const createImg = () => {
        const user = dataCenter?.userInfo
        const canvas = document.createElement('canvas')
        const context = canvas.getContext('2d')
        // context.fillStyle = "cornflowerblue"; //画布填充色
        // context.fillRect(0, 0, 200, 200); //清空画布
        canvas.height = 200
        canvas.width = 200
        context.globalAlpha = 0.04
        context.fillStyle = "black"; //设置字体颜色
        context.font = "18px Arial"; //设置字体
        context.textAlign = "center";
        context.translate(100, 100)
        context.rotate((Math.PI / 180) * -25)
        context.fillText(user?.name + ' ' + user?.id, 0, 0)
        context.translate(-100, -100)
        return canvas.toDataURL('image/png')
    }

    useEffect(() => {
        if (dataCenter.needUpdateIndex) {
            fetchData('/query/queryToolBox', {}, 'toolBox')
                .then(() => fetchData('/typeManage/queryTypeForManage', {}, 'type'))
                .then(() => dispatch(NEED_UPDATE_INDEX()))
        }
    }, [dataCenter.needUpdateIndex])

    useEffect(async () => {
        if (mdLock) return
        if (!!dataCenter?.userInfo) {
            await sendMd(dataCenter?.userInfo, Exposure, 'page_index')
            setMdLock(true)
            dispatch(UPDATE_DATA({backgroundData: createImg()}))
        }
    }, [dataCenter?.userInfo])


    useEffect(async () => {
        await getUser()
        dispatch(NEED_UPDATE_INDEX())
    }, [])

    return (
        <div className="index" style={{backgroundImage: `url(${dataCenter?.backgroundData})`}}>
            <TypeNavBar/>
            <div className="welcome-top">
                    <span>欢迎您！
                        <span className="welcome-uname">{dataCenter?.userInfo?.name}</span>
                        {/*<a className="login-btn">退出登录</a>*/}
                    </span>
            </div>
            <div className="nav">
                <div className="nav-title">
                    <img src={logo} alt=""/>
                </div>
                <div className="nav-weather">
                    <iframe width="360" height="40" frameBorder="0" scrolling="no" hspace="0"
                            src="https://i.tianqi.com/?c=code&a=getcode&id=40&icon=1"/>
                </div>
            </div>
            <IndexContent typeData={[{type_id: 'follow', type_name: '我的收藏'}]}/>
            {
                Array.isArray(dataCenter?.type) && dataCenter?.type?.map(v => (
                    <IndexContent typeData={[v]} key={v.type_id}/>
                ))
            }
            <div className="index-footer">
                兑吧研发中心·杭州兑吧网络科技有限公司版权所有
                <br/>
                浙ICP备14017299号-1
            </div>
        </div>
    )
}

export default Index

