import React from 'react';
import { Button, Modal, Form, Input, Radio, Select, message, Tabs } from 'antd';
import { useContext, useEffect, useState } from "react";
import { Root } from "../dataCenter/Root";
import { NEED_UPDATE_INDEX } from "../dataCenter/action";
const { Option } = Select;
const { TabPane } = Tabs;
const TypeModal = ({ visible, onCancel, queryData, data }) => {
    console.log(data);
    const [form] = Form.useForm();
    if (data) {
        form.setFieldsValue({
            type_name: data.type_name,
        });
    }
    const formItemLayout = {
        labelCol: { span: 4 },
        wrapperCol: { span: 18 },
    };

    const { fetchData, dataCenter, dispatch } = useContext(Root)
    const [value, setValue] = React.useState(1);


    const onCreate = (values) => {
        if (data) {
            console.log(data);

            let input = {
                type_id: '',
                type_name: ''
            }
            if (!data.isRemove) {
                input = {
                    type_id: data.type_id,
                    type_name: values.type_name
                }
            } else {
                input = {
                    child_type_id: data.type_id,
                    child_type_name: values.type_name
                }
            }
            fetchData('/typeManage/updateType', input)
                .then((res) => {
                    if (res.success) {
                        message.success('修改成功')
                        dispatch(NEED_UPDATE_INDEX())
                        queryData()
                        onCancel()
                    }
                })
        } else {
            console.log(values);
            fetchData('/add/addType', values)
                .then((res) => {
                    if (res.success) {
                        message.success('新建成功')
                        dispatch(NEED_UPDATE_INDEX())
                        onCancel()
                    }
                })
        }

    };
    // function callback(key) {
    //     console.log(key);
    // }

    const onChange = e => {
        console.log('radio checked', e.target.value);
        setValue(e.target.value);
    };

    const onGenderChange = (value) => {
        form.setFieldsValue({
            type_id: value,
        });
    };

    return (
        <Modal
            visible={visible}
            title={`${data ? '修改' : '新建'}类型`}
            okText="确定"
            cancelText="取消"
            onCancel={onCancel}
            onOk={() => {
                form
                    .validateFields()
                    .then((values) => {
                        // form.resetFields();
                        onCreate(values);
                    })
                    .catch((info) => {
                        console.log('Validate Failed:', info);
                    });
            }}
        >
            <Form
                form={form}
                // layout="vertical"
                {...formItemLayout}
                name="form_in_modal"
                initialValues={{
                    modifier: 'public',
                    'radio-group': 1
                }}
            >

                {!data && <Form.Item name="radio-group" label="类型">
                    <Radio.Group onChange={onChange} value={value}>
                        <Radio value={1}>父类型</Radio>
                        <Radio value={2}>子类型</Radio>
                    </Radio.Group>
                </Form.Item>}
                {value === 1 || data ? <Form.Item
                    name="type_name"
                    label={`${data ? '' : '父'}类型`}
                    rules={[
                        {
                            required: true,
                            message: '请输入类型名称!',
                        },
                    ]}
                >
                    <Input placeholder="请输入类型名称" />
                </Form.Item> :
                    <>
                        <Form.Item
                            name="type_id"
                            label="父类型"
                            hasFeedback
                            rules={[{ required: true, message: '请选择父类型!' }]}
                        >
                            <Select
                                placeholder="请选择父类型"
                                onChange={onGenderChange}
                            // allowClear
                            >
                                {
                                    dataCenter?.type?.length && dataCenter?.type.map(v => {
                                        return (
                                            <Option key={v.type_id} value={v.type_id}>{v.type_name}</Option>
                                        )
                                    })
                                }

                            </Select>
                        </Form.Item>
                        <Form.Item
                            name="child_type_name"
                            label="子类型"
                            rules={[
                                {
                                    required: true,
                                    message: '请输入类型名称!',
                                },
                            ]}
                        >
                            <Input placeholder="请输入类型名称" />
                        </Form.Item>
                    </>

                }
            </Form>
        </Modal>
    );
};
export default TypeModal
