import React, {useContext, useEffect, useState} from 'react';
import {Root} from "../dataCenter/Root";
import {Modal, Space, Table} from 'antd';
import PublishModal from "./PublishModal"

function PageModal({ visible, onCancel, onPublish }) {

    const [publish, setPublish] = useState(false)
    const [pageData, setpageData] = useState('')
    const { fetchData, dataCenter } = useContext(Root)

    const onChangePage = (values) => {
        console.log(values);
        setpageData(values);
        setPublish(true)
    };
    const onRemovePage = (values) => {
        console.log(values);
        // setVisible(false);
    };



    const columns = [
        {
            title: '页面Id',
            dataIndex: 'page_id',
            width: 150,
            align: 'center'
        },
        {
            title: '页面名称',
            dataIndex: 'page_name',
            width: 200,
            align: 'center'
        },
        {
            title: '页面Url',
            dataIndex: 'pageUrl',
            width: 300,
            align: 'center',
            render: (text, record) => (
                <Space size="middle">
                    <a href={record.pageUrl}>{record.pageUrl}</a>
                </Space>
            ),
        },
        {
            title: '操作',
            key: 'action',
            align: 'center',
            width: 100,
            render: (text, record) => (
                <Space size="middle">
                    <a onClick={() => onChangePage(record)}>替换</a>
                    {/* <a onClick={() => onRemovePage(record)}>删除</a> */}
                </Space>
            ),
        },
    ];


    useEffect(() => {
        console.log(dataCenter);
        dataCenter?.type && fetchData('/page/queryPage', {}, 'queryPage')
            .then((res) => {
            })
    }, [])


    const data = [
        {
            key: '1',
            name: '1 Brown',
            age: 32,
            address: 'New York No. 1 Lake Park',
        },
        {
            key: '2',
            name: '2 Green',
            age: 42,
            address: 'London No. 1 Lake Park',
        },
        {
            key: '3',
            name: '3 Black',
            age: 32,
            address: 'Sidney No. 1 Lake Park',
        },
        {
            key: '4',
            name: '4 Brown',
            age: 32,
            address: 'New York No. 1 Lake Park',
        },
        {
            key: '5',
            name: '5 Green',
            age: 42,
            address: 'London No. 1 Lake Park',
        },
        {
            key: '6',
            name: '6 Black',
            age: 32,
            address: 'Sidney No. 1 Lake Park',
        },
        {
            key: '7',
            name: '7 Brown',
            age: 32,
            address: 'New York No. 1 Lake Park',
        },
        {
            key: '8',
            name: '8 Green',
            age: 42,
            address: 'London No. 1 Lake Park',
        },
        {
            key: '9',
            name: '9 Black',
            age: 32,
            address: 'Sidney No. 1 Lake Park',
        },
        {
            key: '10',
            name: '10 Brown',
            age: 32,
            address: 'New York No. 1 Lake Park',
        },
        {
            key: '11',
            name: '11 Green',
            age: 42,
            address: 'London No. 1 Lake Park',
        },
        {
            key: '12',
            name: '12 Black',
            age: 32,
            address: 'Sidney No. 1 Lake Park',
        },
    ];
    return (
        <>
            <Modal
                visible={visible}
                title="页面管理"
                okText="确定"
                cancelText="取消"
                width='1000px'
                onCancel={onCancel}
                onOk={onCancel}
            >
                <Table columns={columns} dataSource={dataCenter?.queryPage && dataCenter.queryPage} pagination={{ pageSize: 10 }} size="middle" />
            </Modal>
            {publish && <PublishModal
                visible={publish}
                onCancel={() =>
                    setPublish(false)
                }
                data={pageData}
            />}
        </>
    )
}

export default PageModal
