const initDataCenter = {
    toolBox: null,
    type: null,
    childType: null,
    userInfo: null,
    needUpdateIndex: false,
    type_id: 'follow',
    child_type_id: 'all'
}

/**
 * deepFreeze()
 * @param obj
 * @returns {unknown[]}
 */
function deepFreeze(obj) {
    // 取回定义在obj上的属性名
    let propNames = Object.getOwnPropertyNames(obj);

    // 在冻结自身之前冻结属性
    propNames.forEach(function (name) {
        let prop = obj[name];

        // 如果prop是个对象，冻结它
        if (typeof prop == 'object' && prop !== null)
            deepFreeze(prop);
    });

    // 冻结自身(no-op if already frozen)
    return Object.freeze(obj);
}

//任何修改原始对象的操作都是禁止的！
deepFreeze(initDataCenter)

const dataReducer = (state, action) => {
    console.log(action)
    // console.table(action,['dataCenter的dispatch'])
    switch (action.type) {
        case 'UPDATE_DATA':
            return Object.assign({}, state, {
                ...action.data
            })
        case 'NEED_UPDATE_INDEX':
            return Object.assign({}, state, {needUpdateIndex: !state.needUpdateIndex})
        case 'CHANGE_TYPE':
            return Object.assign({}, state, {type_id: action.type_id})
        case 'CHANGE_CHILD_TYPE':
            return Object.assign({}, state, {child_type_id: action.child_type_id})
        default:
            return state
    }
}

export {
    initDataCenter,
    dataReducer,
}
