import React, {createContext, useReducer} from "react";
import {dataReducer, initDataCenter} from "./reducer";
import apiConfig from "../config/apiConfig";
import {UPDATE_DATA} from "./action";
import generateUrl from "../utils/generateUrl";

const Root = createContext({})
const PopContext = createContext({})

function DataCenter(props) {
    const [dataCenter, dispatch] = useReducer(dataReducer, initDataCenter, () => {
        return initDataCenter
    })


    const fetchData = async (path, requestData, dataName) =>
        fetch(generateUrl(path, requestData), {credentials: 'include'})
            .then(res => res.json())
            // .then(res => res.text())
            .then(res => {
                console.log('res:',res);
                if (res.success) {
                    !!dataName && dispatch(UPDATE_DATA({[dataName]: res.data}))
                } else {
                    return res
                }
                return res
            })
            .catch(e => {
                console.error(e)
                return e
            })


    return (
        <Root.Provider value={{dataCenter, dispatch, fetchData}}>
            {
                props.children
            }
        </Root.Provider>
    )
}

export {
    Root,
    PopContext,
}
export default DataCenter

