import React, {useContext, useEffect, useState} from "react";
import './TypeNavBar.scss'
import {Root} from "../../dataCenter/Root";
const scrollTo = id => {
    console.log('跳转')
    // location.href = '#type' + id
    document.getElementById('type' + id)?.scrollIntoView({block: "start", behavior: "smooth"})
}

const NavItem = props => {
    const {typeName, typeId, selected} = props
    return (<div className='nav-item' style={selected ? {backgroundColor: '#00D5CA', color: '#fff'} : {}}
                 onClick={() => scrollTo(typeId)}>{typeName}</div>)
}

function TypeNavBar() {

    const {dataCenter} = useContext(Root)
    const [showNav, setShowNav] = useState(true)
    const [effectLock, setEffectLock] = useState(false)
    const [selectedTypeIndex, setSelectedTypeIndex] = useState(-1)

    const getOffsetOffsetTops = arr => arr.map(v => document.getElementById('type' + v).offsetTop)

    const getHashParams = ()=>{
        const hashStr = window.location.hash
        const paramsStrArr = hashStr.split('?')[1]?.split('&')
        const params = {typeId: null}
        if ( !paramsStrArr?.length) return null
        paramsStrArr.forEach(v => {
            const _v = v.split('=')
            params[_v[0]] = _v[1]
        })
        return params
    }

    useEffect(()=>{
        if (!!dataCenter?.type){
            if (selectedTypeIndex === -1) return window.location.hash = '#/index'
            window.location.hash = '#/index?typeId=' + dataCenter.type[selectedTypeIndex].type_id
        }
    },[selectedTypeIndex])

    useEffect(() => {
        if (effectLock) return
        if (!!dataCenter?.type) {
            if(!!getHashParams()?.typeId) scrollTo(getHashParams()?.typeId)
            const ids = dataCenter?.type?.map(v => v.type_id)
            const offsetArr = getOffsetOffsetTops(ids)
            const followOffset = document.getElementById('typefollow').offsetTop
            document.body.addEventListener('scroll', e => {
                let min = {offsetTop: Math.abs(e.target['scrollTop'] - offsetArr[0]), index: 0}
                for (let i = 0; i < offsetArr.length; i++) {
                    const delta = Math.abs(e.target['scrollTop'] - offsetArr[i])
                    if (delta < min.offsetTop) {
                        min.offsetTop = delta
                        min.index = i
                    }
                }
                if (min.offsetTop > Math.abs(e.target['scrollTop'] - followOffset)) return setSelectedTypeIndex(-1)
                setSelectedTypeIndex(min.index)
            })
            setEffectLock(true)
        }
    }, [dataCenter?.type])
    return (
        <div className='type-nav-bar' style={{transform: `translateX(${showNav ? 0 : -120}px)`}}>
            <div className="guide-button"
                 onClick={() => setShowNav(!showNav)}
                 style={showNav ? {
                     width: '120px',
                     transform: 'translate(-50px,-30px)',
                     borderBottomRightRadius: '1px',
                     borderBottom: '1px solid #f5f5f5'
                 } : {borderBottomRightRadius: '10px'}}
            >{showNav ? '导航 <' : '导航 >'}
            </div>
            {
                dataCenter?.type?.length > 0 && dataCenter?.type?.map((v, i) => (
                    <NavItem selected={selectedTypeIndex === i} key={v.type_id} typeId={v.type_id}
                             typeName={v.type_name}/>))
            }
        </div>
    )
}

export default TypeNavBar
