import './ToolType.scss'
import {useContext} from "react";
import {Root} from "../../dataCenter/Root";

const ChildTypeItem = props => {
    const {dataCenter, dispatch} = useContext(Root)
    const {childTypeId, child_type_id, child_type_name, setChildTypeId} = props
    const classNameArr = ['child-type-item']
    if (child_type_id === childTypeId) {
        classNameArr.push('child-type-item-selected')
    }
    const handleClick = () => {
        setChildTypeId(child_type_id)
    }
    return (
        <div className={classNameArr.join(' ')} onClick={handleClick}>{child_type_name}</div>
    )
}


function ToolType(props) {
    const {typeData, setChildTypeId, setTypeId, typeId, childTypeId} = props
    const {dataCenter, dispatch} = useContext(Root)
    const getTypeData = ()=>{
        return typeData.filter(v => v.type_id === typeId)[0]
    }
    if (!Array.isArray(typeData)) return (<div>无数据,或数据格式错误</div>)
    return (
        <>
            <div className="tab-tool-type">
                {
                    Array.isArray(typeData) && typeData.map(v => (
                        <div
                            className={typeId === v.type_id ? 'item-tool-type item-tool-type-selected' : 'item-tool-type'}
                            onClick={() => setTypeId(v?.type_id)} key={v.type_id}>
                            {v?.type_name}
                        </div>
                    ))
                }

            </div>
            <div className="child-type">
                {
                    (typeId !== 'all' && typeId !== 'follow') &&
                    <ChildTypeItem key={'all'} child_type_id={'all'} child_type_name={'全部'}
                                   setChildTypeId={setChildTypeId} childTypeId={childTypeId}/>
                }
                {
                    Array.isArray(getTypeData()?.children) && getTypeData().children.map(v => {
                        return (
                            <ChildTypeItem key={v.child_type_id} child_type_id={v.child_type_id}
                                           child_type_name={v.child_type_name}
                                           setChildTypeId={setChildTypeId}
                                           childTypeId={childTypeId}
                            />
                        )
                    })
                }
            </div>
        </>
    )
}

export default ToolType
