import ToolType from "../ToolType/ToolType";
import {useContext, useEffect, useRef, useState} from "react";
import ContentAdmin from "../ContentAdmin/Content";
import {Root} from "../../dataCenter/Root";
import {NEED_UPDATE_INDEX} from "../../dataCenter/action";


function IndexContent(props) {
    const {fetchData, dispatch} = useContext(Root)
    const {typeData} = props
    const [typeId, setTypeId] = useState(typeData[0].type_id)
    const [childTypeId, setChildTypeId] = useState('all')
    const inputRef = useRef({weight: typeData[0]?.weight})
    useEffect(() => {
        console.log({typeId: typeId, weight: typeData[0]?.weight})
    }, [])
    const changeWeight = async (type, weight) => {
        switch (type) {
            case 'up':
                await fetchData('/typeManage/changeWeight', {typeId: typeId, weight: typeData[0]?.weight + 1})
                break
            case 'down':
                await fetchData('/typeManage/changeWeight', {typeId: typeId, weight: typeData[0]?.weight - 1})
                break
            case 'to':
                await fetchData('/typeManage/changeWeight', {typeId: typeId, weight: weight})
                break
        }
        dispatch(NEED_UPDATE_INDEX())
    }
    return (
        <>
            <div className="tool-nav">
                <span>当前权值：{typeData[0]?.weight}</span>
                <button className="type-weight" onClick={()=>changeWeight('up')}>向上一级</button>
                <button className="type-weight" onClick={()=>changeWeight('down')}>向下一级</button>
                <button className="type-weight" onClick={()=>changeWeight('to', inputRef.current['weight'])}>
                    变更权值为：
                    <input type='text' defaultValue={typeData[0].weight} onChange={e => inputRef.current['weight'] = e.target.value} onClick={e => e.stopPropagation()}/>
                </button>
                <ToolType typeData={typeData} setChildTypeId={setChildTypeId} setTypeId={setTypeId} typeId={typeId}
                          childTypeId={childTypeId}/>
            </div>
            <div className="container">
                <ContentAdmin typeId={typeId} childTypeId={childTypeId}/>
            </div>
        </>
    )
}

export default IndexContent
