import './Content.scss'
import {useContext} from "react";
import {Root} from "../../dataCenter/Root";
import ContentItemAdmin from "./ContentItemAdmin";

function ContentAdmin(props) {
    const {childTypeId, typeId} = props
    const {dataCenter} = useContext(Root)
    return (
        <div className="content">
            {
                dataCenter.toolBox?.length ? dataCenter?.toolBox
                        .filter(v => {
                            if (typeId === 'all') return true
                            else if (typeId === 'follow') return dataCenter?.userInfo?.follow?.includes(v.type_id)
                            else return v.type_id === typeId
                        })
                        .filter(v => {
                            if (childTypeId === 'all') return true
                            else return v.child_type_id === childTypeId
                        }).map(v => {
                            return (
                                <ContentItemAdmin key={v['toolbox_id']} value={v}/>
                            )
                        })
                    :
                    '没有数据了！'
            }
        </div>
    )
}

export default ContentAdmin
