import './Content.scss'
import ContentItem from "./ContentItem";
import {useContext} from "react";
import {Root} from "../../dataCenter/Root";

function Content(props) {
    const {childTypeId, typeId} = props
    const {dataCenter} = useContext(Root)
    return (
        <div className="content" style={{backgroundImage: `url(${dataCenter?.backgroundData})`}}>
            {
                !!dataCenter.toolBox?.length && dataCenter?.toolBox
                    .filter(v => {
                        if (typeId === 'all') return true
                        else if (typeId === 'follow') return dataCenter?.userInfo?.follow?.includes(v.toolbox_id)
                        else return v.type_id === typeId
                    })
                    .filter(v => {
                        if (childTypeId === 'all') return true
                        else return v.child_type_id === childTypeId
                    }).map(v => {
                        return (
                            <ContentItem key={v['toolbox_id']} value={v}/>
                        )
                    })
            }
            {
                (typeId === 'follow' && dataCenter?.userInfo?.follow?.length <= 0) && '没有数据了！'
            }
        </div>
    )
}

export default Content
