const express = require('express');
const router = express.Router();
const getMysql = require('../SQLPool')
const configDev = require("../../config/dev.json");
const request = require("request");
const SsoOauth2 = require('sso-oauth2').default
const ssoOauth2 = new SsoOauth2(configDev.SSO)
const query = require('../lib/query')
const config = require('../../config/getConfig')()


const ErrorCode = {
    USER_NOT_LOGIN: 70001
}
getMysql.then(Mysql => {
    router.get('/addAdmin', async (req, res) => {
        const {uid} = req.query
        const SQL = 'UPDATE `user` SET `admin` = 1 WHERE `uid` = ?'
        try {
            const addAdmin = await query(SQL, [uid])
            res.send({
                success: true,
                result: addAdmin
            })
        } catch (e) {
            console.error(e)
            res.send({
                success: false,
                err: e
            })
        }

    })
    /* GET users listing. */
    router.get('/getUser', async (req, res) => {

        if (config === 'local'){
            res.send({
                success: true,
                data: {
                    id: 101010,
                    name: 'admin',
                    admin: 1
                }
            })
            return
        }


        const {sso_ticket} = req.cookies
        console.info('cookies: ', req.cookies)
        if (!sso_ticket) {
            res.send({
                success: false,
                code: ErrorCode.USER_NOT_LOGIN,
                data: '用户尚未登录'
            })
            return
        }
        const ssoData = await ssoOauth2.getUserInfo(sso_ticket)
        if (ssoData) {
            const SQL = 'SELECT * FROM user WHERE uid=?'
            Mysql.query(SQL, [ssoData['id']], (err, result) => {
                if (err) {
                    console.error(err)
                    res.send({
                        success: false,
                        err: err
                    })
                    return
                }
                if (Array.isArray(result) && result.length > 0) {
                    console.info('用户查询：', result)
                    const admin = +result[0]['admin'] === 1 ? {admin: result[0]['admin']} : {}
                    res.send({
                        success: true,
                        data: Object.assign(ssoData, {follow: JSON.parse(result[0].follow)}, admin)
                    })
                } else {
                    const _SQL = 'INSERT INTO `user` (uid, uname, follow) VALUES (?,?,?)'
                    const _params = [ssoData['id'], ssoData['name'], JSON.stringify([])]
                    Mysql.query(_SQL, _params, (_err, _result) => {
                        if (_err) {
                            console.error(_err)
                            res.send({
                                success: false,
                                err: _err
                            })
                            return
                        }
                        res.send({
                            success: true,
                            data: Object.assign(ssoData, {follow: []}),
                            message: '新增用户数据'
                        })
                    })
                }
            })

        } else {
            res.send({
                success: false,
                code: ErrorCode.USER_NOT_LOGIN,
                err: '未获取到用户信息！'
            })
        }


        // const SQL = 'SELECT * FROM `user` WHERE `user`.uid = ?'
        // Mysql.query(SQL, [uid], (err, result) => {
        //     if (err || !result || !result.length) {
        //         res.send({
        //             success: false,
        //             err
        //         })
        //         return
        //     }
        //     console.log(result)
        //     const _result = result.slice()
        //     _result[0].follow = JSON.parse(_result[0].follow)
        //     res.send({
        //         success: true,
        //         data: {
        //             ..._result[0],
        //         }
        //     })
        // })
    });

    router.get('/login', (req, res) => {
        const {uid} = req.query
        const SQL = 'SELECT * FROM `user` WHERE `user`.uid = ?'
        Mysql.query(SQL, [uid], (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    err
                })
                throw err
            }
            if (!!result && result[0].uid) {
                res.cookie('uid', result[0].uid)
                res.send({
                    success: true,
                    data: '登录成功！'
                })
            } else {
                res.send({
                    success: false,
                    data: '登录失败，用户不存在'
                })
            }
        })
    })

    router.get('/follow', (req, res) => {
        const {follow, uid} = req.query
        const SQL = 'UPDATE user SET follow = ? WHERE uid = ?'
        Mysql.query(SQL, [follow, uid], (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    err
                })
                return
            }
            res.send({
                success: true,
            })
        })
    })
}).catch(e => {
    console.error(e)
})
module.exports = router;
