const express = require('express')
const request = require("request");
const query = require('../lib/query')
const getMysql = require('../SQLPool')
const router = express.Router()
getMysql.then(Mysql => {

    router.get('/changeWeight', async (req, res) => {
        const {typeId, weight} = req.query
        const SQL = 'UPDATE type SET type.weight = ? WHERE type_id = ?'
        try {
            const changeRes = await query(SQL, [weight, typeId])
            if (changeRes['affectRows'] <= 0) throw 'type,weight,变更失败'
            res.send({
                success: true
            })
        } catch (e) {
            res.send({
                success: false,
                err: e
            })
        }
    })

    router.get('/queryType', (req, res) => {
        const SQL = 'SELECT * FROM type'
        Mysql.query(SQL, (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    err
                })
                return
            }
            res.send({
                success: true,
                data: result
            })
        })
    })

    router.get('/queryChildType', (req, res) => {
        const SQL = 'SELECT * FROM child_type'
        Mysql.query(SQL, (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    err
                })
                return
            }
            res.send({
                success: true,
                data: result
            })
        })
    })

    router.get('/queryTypeForManage', async (req, res) => {
        try {
            const SQL1 = 'SELECT * FROM type'
            const SQL2 = 'SELECT * FROM child_type'
            const typeArr = await query(SQL1)
            const _typeArrSorted = typeArr.slice().sort((a, b) => b['weight'] - a['weight'])
            const childTypeArr = await query(SQL2)
            const data = _typeArrSorted.map(v => ({
                ...v,
                children: childTypeArr.filter(_v => _v.type_id === v.type_id)
            }))
            res.send({
                success: true,
                data: data,
            })
        } catch (e) {
            console.error(e)
            res.send({success: false, err: e})
        }
    })


    router.get('/deleteChildType', ((req, res) => {
        const {child_type_id} = req.query

        let SQL = 'DELETE FROM child_type WHERE child_type_id = ?;'
        let SQL2 = 'DELETE FROM type_childtype_toolbox WHERE child_type_id = ?;'

        Mysql.query(SQL, [child_type_id], (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    err
                })
                return
            }
            Mysql.query(SQL2, [child_type_id], (err, result) => {
                res.send({
                    success: true,
                })
            })

        })
    }))

    router.get('/updateType', (req, res) => {
        const {type_id, type_name, child_type_id, child_type_name} = req.query
        let SQL
        const values = []
        if (type_id) {
            SQL = 'UPDATE type SET type_name = ? WHERE type_id = ?'
            values.push(type_name)
            values.push(type_id)
        } else {
            SQL = 'UPDATE child_type SET child_type_name = ? WHERE child_type_id = ?'
            values.push(child_type_name)
            values.push(child_type_id)
        }
        Mysql.query(SQL, values, (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    err
                })
                return
            }
            res.send({
                success: true,
            })
        })
    })
}).catch(e => console.error(e))


module.exports = router
