const express = require('express')
const router = express.Router()
const config = require('../../config/getConfig')()
const SsoOauth2 = require('sso-oauth2').default
const ssoOauth2 = new SsoOauth2({
    ...config.SSO,
    // appSecret: global['SSO_APP_SECRET']
})


router.get('/ssoIndex', async (req, res) => {
    const {ssoStamp, redirect} = req.query
    if (!global['SSO_APP_SECRET']) {
        res.send({
            message: '缺少appSecret'
        })
        console.info('缺少appSecret')
        return;
    }
    console.info('ssoConfig:',{
        ...config.SSO,
        appSecret: global['SSO_APP_SECRET']
    })
    console.info('ssoStamp', ssoStamp)
    try {
        const ticket = await ssoOauth2.getTicket(ssoStamp)
        if (ticket){
            res.cookie('sso_ticket',ticket)
        }
        console.info('sso-ticket:', ticket)
        const ssoData = await ssoOauth2.getUserInfo(ticket)
        console.info('sso-data:', ssoData)
        if (ssoData['name']) {
            res.redirect(decodeURIComponent(redirect))
            // await res.send({
            //     success: true,
            //     ssoData
            // })
        } else {
            res.send({
                success: false,
                err: '未获取到用户信息！'
            })
        }
    } catch (e) {
        console.error(e)
        res.send({
            success: false,
            err: e
        })
    }
})


module.exports = router
