const express = require('express')
const request = require("request");
// const Mysql = require('../SQLPool')
const getMysql = require('../SQLPool')
const router = express.Router()
getMysql.then(Mysql => {
    router.get('/queryType', (req, res) => {
        const SQL = 'SELECT * FROM type'
        Mysql.query(SQL, (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    err
                })
            }
            res.send({
                success: true,
                data: result
            })
        })
    });

    router.get('/queryChildType', (req, res) => {
        const {type_id} = req.query
        const SQL = 'SELECT child_type.child_type_id, child_type.child_type_name, child_type.type_id FROM child_type INNER JOIN type ON child_type.type_id = type.type_id WHERE type.type_id = ?'
        Mysql.query(SQL,[type_id], (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    err
                })
            }
            res.send({
                success: true,
                data: result
            })
        })
    });


    router.get('/queryToolBox', (req, res) => {
        let SQL = `SELECT toolbox.*, type_childtype_toolbox.child_type_id, type_childtype_toolbox.type_id FROM type_childtype_toolbox INNER JOIN toolbox ON type_childtype_toolbox.toolbox_id = toolbox.toolbox_id`
        Mysql.query(SQL, [], (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    err
                })
                throw err
            }

            res.send({
                success: true,
                data: [...result.map(v => ({...v,toolbox_url : v['toolbox_url']}))]
            })
        })
    });
}).catch(e => console.error(e))


// router.get('/queryToolBoxSortId', (req, res) => {
//     const SQL = 'SELECT sortId FROM toolbox'
//     Mysql.query(SQL, (err, result) => {
//         if (err) {
//             res.send({
//                 success: false,
//                 err
//             })
//             throw err
//         }
//         const _result = []
//         result.map(v => _result.push(v["sortId"]))
//         res.send({
//             success: true,
//             data: _result.sort((a, b) => a - b)
//         })
//     })
// })

module.exports = router
