const express = require('express');
const getMysql = require('../SQLPool')
const fs = require("fs");
const request = require("request");
const path = require("path");
const router = express.Router();

getMysql.then(Mysql => {
    router.post('/addPage', (req, res) => {
        const {page_name, code} = req.body
        const SQL = `INSERT INTO page (page_name,page_content) VALUES (?,?)`

        Mysql.query(SQL, [page_name, code], (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    error: err
                })
                return
            }
            res.send({
                success: true,
            })
        })
    })


    router.get('/queryPage', (req, res) => {
        const SQL = 'SELECT * FROM page'
        Mysql.query(SQL, [], (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    err
                })
            }

            const _result = result.map(v => {
                const url = global.domain + '/page/publicPage?' + 'page_id=' + v['page_id']
                return {
                    ...v,
                    pageUrl: url
                }
            })

            res.send({
                success: true,
                data: _result
            })
        })
    })


    router.get('/publicPage', (req, res) => {
        res.set({'Content-Type': 'text/html; charset=utf-8'})
        const {page_id} = req.query
        const SQL = 'SELECT * FROM page WHERE page_id = ?'
        Mysql.query(SQL, [page_id], (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    error: err
                })
                return
            }
            res.send(result[0]['page_content'])
        })
    })

    router.post('/updatePage', (req, res) => {
        const {page_id, page_name, code} = req.body
        const SQL = 'UPDATE page SET page_name=? ,page_content=?  WHERE page_id = ?'
        Mysql.query(SQL, [page_name, code, page_id], (err, result) => {
            if (err) {
                res.send({
                    success: false,
                    error: err
                })
                return
            }
            res.send({
                success: true
            })
        })
    })
}).catch(e => console.error(e))


module.exports = router
