const express = require('express')
const query = require('../lib/query')
const router = express.Router()


router.get('/addMd', async (req, res) => {
    const {uid, uname, type, info, timestamp} = req.query
    // const SQL_query = 'SELECT * FROM md WHERE md_user_id = ? AND md_type = ? AND md_info = ?'
    // const SQL_add = 'UPDATE md SET md.last_time = ? , md.md_num = md.md_num + 1 WHERE md.md_id = ?'
    const SQL_addNew = `INSERT INTO md (md.md_user_id, md.md_user_name, md.md_type, md.md_num, md_info, last_time) VALUES (?,?,?,1,?,?)`
    try {
        const addNewRes = await query(SQL_addNew, [uid, uname, type, info, String(timestamp)])
        if (addNewRes['affectedRows'] > 0) res.send({success: true, message: '新增埋点'})
        res.send({success: true})
    } catch (e) {
        console.error(e)
        res.send({success: false, err: e})
    }
})


router.get('/queryAllMd', async (req, res) => {
    const SQL = 'SELECT * FROM md'
    try {
        const mdInfo = await query(SQL, [])
        res.send({
            success: true,
            data: mdInfo
        })
    } catch (e) {
        console.error(e)
        res.send({success: false, err: e})
    }

})


module.exports = router
