const express = require('express')
const request = require('request')
const getMysql = require('../SQLPool')
const router = express.Router()
const query = require('../lib/query')

getMysql.then(Mysql => {
    router.get('/deleteType', async (req,res) => {
        const {type_id} = req.query
        const SQL = 'DELETE FROM type WHERE type_id = ?'
        try {
            const deleteType = await query(SQL, [type_id])
            res.send({
                success: true,
                result: deleteType
            })
        }catch (e){
            console.error(e)
            res.send({
                success: false,
                err: e
            })
        }



    })
    router.get('/deleteToolBoxById', (req, res) => {
        const {toolbox_id} = req.query
        const SQL = 'DELETE FROM toolbox WHERE toolbox_id = ?'
        try {
            Mysql.query(SQL, [toolbox_id], (err, result) => {
                if (err) {
                    res.send({
                        success: false,
                        err
                    })
                    throw err
                }
                res.send({
                    success: true,
                    data: result
                })
            })
        }catch (e){
            console.error(e)
        }

    })
}).catch(e => console.error(e))

module.exports = router
