const express = require('express')
const request = require("request");
const getMysql = require('../SQLPool')
const router = express.Router()
const query = require('../lib/query')
getMysql.then(Mysql => {
    router.get('/addToolBox', async (req, res) => {
        const {toolbox_name, toolbox_icon, toolbox_desc, toolbox_url, type_id, child_type_id} = req.query
        const SQL1 = 'INSERT INTO toolbox (toolbox_name, toolbox_icon, toolbox_desc, toolbox_url,sort_id) VALUES (?,?,?,?,?)'
        const SQL2 = 'INSERT INTO type_childtype_toolbox (toolbox_id,type_id,child_type_id) VALUES (?,?,?)'
        const SQL3 = 'SELECT * FROM toolbox'
        try{
            const addToolBox = await query(SQL1, [toolbox_name, toolbox_icon, toolbox_desc, toolbox_url, 0])
            if (!addToolBox) throw 'addToolBox异常'

            const queryToolBox = await query(SQL3)
            if (!queryToolBox) throw '没有toolbox信息'

            const lastToolBoxId = queryToolBox[queryToolBox.length - 1].toolbox_id
            const params = [lastToolBoxId, type_id]
            !!String(child_type_id).match(/[^0-9]/) ? params.push(null) :  params.push(child_type_id)

            const addRelation = await query(SQL2, params)
            if (addRelation) res.send({success: true})
            else throw 'addRelation异常'
        }catch (e){
            console.error(e)
            res.send({
                success: false,
                err: e
            })
        }
    })

    router.get('/addType', (req, res) => {
        const {type_name, child_type_name, type_id} = req.query
        console.log(req.query)
        let SQL = 'INSERT INTO type (type_name) VALUES (?)'
        const values = []
        if (child_type_name && type_id) {
            SQL = 'INSERT INTO child_type (child_type_name, type_id) VALUES (?,?)'
            values.push(child_type_name)
            values.push(type_id)
        } else {
            values.push(type_name)
        }
        console.log(values)
        try {
            Mysql.query(SQL, values, (err, result) => {
                if (err) {
                    res.send({
                        success: false,
                        err
                    })
                    throw err
                }
                res.send({
                    success: true,
                    data: result
                })
            })
        } catch (e) {
            console.error(e)
        }
    })
}).catch(e => console.error(e))


module.exports = router
