const axios = require('axios')
const md5 = require('./md5')
const configDev = require('../../config/dev.json')

let ssoConf = configDev.SSO

module.exports = {
  init: function (opts) {
    ssoConf = opts
  },

  /**
   * 统一封装请求java接口
   */
  buildInterFaceUrl: function(interfaceName, ...args) {
    let params = {}
    for (let i = 0; i < args.length; i++) {
      if (typeof args[i] === 'string') {
        args[i] = '"' + args[i] + '"'
      }
      params['_p' + i] = args[i]
    }

    let appSecret = ssoConf.appSecret
    let profiles = ssoConf.profiles
    let systemName = ssoConf.systemName
    let timestamp = Date.parse(new Date())
    let newString = appSecret + interfaceName + profiles + systemName + timestamp
    let sign = md5.SECURITY.duiba_md5(newString)
    let headSignStr = JSON.stringify({
      systemName,
      interfaceName,
      timestamp,
      profiles,
      sign
    })
    console.info('signStr:',appSecret + interfaceName + profiles + systemName + timestamp)
    console.info('headSignStr:',headSignStr)
    let headSign = encodeURI(headSignStr)
    let url = ssoConf.ssourl + interfaceName //op
    console.info('发送请求:',{
      method: 'get',
      url: url,
      params: params,
    })
    return new Promise((resolve, reject) => {
      axios({
        headers: {
          'X-SSO-MR': true,
          'X-Rpc': true,
          'X-SSO-SIGN': headSign
        },
        method: 'get',
        url: url,
        params: params,
      }).then(data => {
        resolve(data.data)
      }).catch(err => {
        reject(err)
      });
    })
  }
}
