const qs = require('querystring')

let ssoConf = null
let util = require('./util')
class Sso {
  /**
   * context sso constructor
   * @api public
   */

  constructor(ctx, opts) {
    this.ctx = ctx
    this.app = ctx.app
    ssoConf = opts || {}
    util.init(ssoConf)
  }

  /**
   * 通过凭证获取的通行证（原来使用链接参数方式跨域传递通行证，不安全）
   * @return ticket
   */
  async findTicketByStamp() {
    const params = qs.parse(this.ctx.request.querystring)

    if (!params.ssoStamp) {
      if (this.ctx.cookies.get('sso_ticket')) {
        return this.ctx.cookies.get('sso_ticket')
      }
    }

    let interfaceName = 'remoteSSOService/findTicketByStamp'
    let ticket = await util.buildInterFaceUrl(interfaceName, ssoConf.systemId, params.ssoStamp)
    this.ctx.cookies.set('sso_ticket', ticket, {
      maxAge: 24 * 60 * 60 * 1000, // cookie有效时长
    })

    return ticket
  }

  /**
   * 登录验证接口
   * @param ticket
   * @return 验证失败返回null
   */
  async verifyTicketAndGetAdmin(ticket) {
    ticket = ticket || this.ctx.cookies.get('sso_ticket')
    const interfaceName = 'remoteSSOService/verifyTicketAndGetAdmin'

    return await util.buildInterFaceUrl(interfaceName, ticket)
  }

  /**
   * 获取一个用户所有的角色
   * @param adminId 员工Id
   */
  async getAdminAllRoles() {
    const interfaceName = 'remotePermissionService/getAdminAllRoles'
    const adminInfo = await this.verifyTicketAndGetAdmin(this.ctx.cookies.get('sso_ticket'))
    return await util.buildInterFaceUrl(interfaceName, ssoConf.systemId, adminInfo.id)
  }

  /**
   * 获取管理员在指定系统下的权限
   * @param adminId 员工Id
   */
  async getPowerIdsBySystemIdAndAdminId() {
    const interfaceName = 'remotePermissionService/getPowerIdsBySystemIdAndAdminId'
    const adminInfo = await this.verifyTicketAndGetAdmin(this.ctx.cookies.get('sso_ticket'))
    return await util.buildInterFaceUrl(interfaceName, ssoConf.systemId, adminInfo.id)
  }

  /**
   * 加载权限树
   */
  async loadPowerList() {
    const interfaceName = 'remotePermissionService/loadPowerList'

    return await util.buildInterFaceUrl(interfaceName, ssoConf.systemId)
  }

  /**
   * 登出
   */
  async outLogin(ticket) {
    ticket = ticket || this.ctx.cookies.get('sso_ticket')
    this.ctx.cookies.set('sso_ticket', '')
    const interfaceName = '/remoteSSOService/outLogin'

    return await util.buildInterFaceUrl(interfaceName, ticket)
  }

  /**
   * 获取sso当前域名
   */
  async findSsoHomeUrl(ticket) {
    ticket = ticket || this.ctx.cookies.get('sso_ticket')
    const interfaceName = 'remoteSSOService/findSsoHomeUrl'

    return await util.buildInterFaceUrl(interfaceName, ticket)
  }
  /**
   * 获取系统下所有的角色role
   */
  async getApplicationAllRoles(){
    const interfaceName='remotePermissionService/getApplicationAllRoles'
    return await util.buildInterFaceUrl(interfaceName, ssoConf.systemId)
  }
  /**
   * 根据role，获取该role下所有的人，不传则返回所有能访问系统的人
   * @param {*} role 
   */
  async findAdminsByRoleName(role){
    const interfaceName = 'remoteAdminService/findAdminsByRoleName'
    return await util.buildInterFaceUrl(interfaceName, ssoConf.systemId, role)
  }
}

module.exports = Sso
