const express = require('express');
const path = require('path');
const cookieParser = require('cookie-parser');
const logger = require('morgan');
const bodyParser = require('body-parser')
const engines = require('consolidate')
const os = require('os')
const usersRouter = require('./routes/users');
const queryRouter = require('./routes/query')
const addRouter = require('./routes/add')
const deleteRouter = require('./routes/delete')
const updateRouter = require('./routes/update')
const submitRouter = require('./routes/page')
const ssoRouter = require('./routes/sso')
const mdRouter = require('./routes/md')
const typeManage = require('./routes/typeManage')
const Eureka = require('eureka-node').default
const DockerApp = require('docker-app-node')
const config = require('../config/getConfig')()
const http = require('http')


const app = express();

if (config === 'local'){
    let server = http.createServer(app);
    server.listen(8001, '127.0.0.1')
    global.domain = 'http://127.0.0.1:8001'
}else {
    global.domain = `//dui123.dui88${config.env === 'prod' ? '' : config.env}.com`
    const dockerApp = new DockerApp({
        app,
        appType: 'express',
        port:3000
    })

// 注册Eureka
    global.eureka = new Eureka({
        port: 3000, // 应用端口号
        appName: 'dui123', // 应用名称
        services: ['dui123'] // 依赖服务名
    })

    global.eureka.start().then(() => {
        dockerApp.startServer().then(()=>{
            console.info('eureka已启动')
            console.info('dockerApp已启动')
        })
    })
}


console.info(global.domain)

//
// app.use((req,res, next) => {
//     const {sso_ticket} = req.cookies
//     if (!sso_ticket){
//         res.send({
//             success: false,
//             message: '用户未登录！',
//             code: 700001
//         })
//     }
// })


app.use((req, res, next) => {
    const url = req.url
    const header = {
        'Content-Type': ''
    }
    if (config === 'local'){
        header['Access-Control-Allow-Credentials'] = true
        header['Access-Control-Allow-Origin'] = req.headers.origin || '*'
        header['Access-Control-Allow-Headers'] = 'X-Requested-With,Content-Type'
        header['Access-Control-Allow-Methods'] = 'PUT,POST,GET,DEconstE,OPTIONS'
    }

    if (url.includes('static')){
        if (url.includes('html')) header["Content-Type"] = 'text/html; charset=utf-8'
        else if (url.includes('css')){
            header["Content-Type"] = 'text/css; charset=utf-8'
        }
        else if(url.includes('js'))  header["Content-Type"] = ' text/javascrpt; charset=utf-8'
    }
    //设置相应头
    res.set(header)
    next()
})



app.use(bodyParser.urlencoded({extended: false}))
app.use(bodyParser.json())
app.use(logger('dev'));
app.use(cookieParser());
app.engine('html', engines.mustache)
app.set('view engine', 'html')
app.set('views', path.join(__dirname, '/staticFile/build'));
app.get('/', function(req, res){
    res.type('html')
    res.render('index.html');
});
app.use('/staticFile', express.static(path.join(__dirname, 'staticFile')));
app.use('/static',express.static(path.join(__dirname, 'staticFile/build/static')))

// app.use('/', indexRouter);
app.use('/users', usersRouter);
app.use('/query', queryRouter)
app.use('/add', addRouter)
app.use('/delete', deleteRouter)
app.use('/update', updateRouter)
app.use('/page', submitRouter)
app.use('/typeManage', typeManage)
app.use('/sso',ssoRouter)
app.use('/md', mdRouter)
