const MYSQL = require('mysql')
const config = require('../config/getConfig')()
const apollo = require('@tuia/apollo')

//应用数据库
console.info('CONFIG:', config)

const getApollo = async () => {
    const apolloConfig = await apollo.getApolloConfig({
        systemName: 'dui123',
        env: config.env,
        accessKey: config.secret
    })
    console.info(apolloConfig)
    const sourcesArray = apolloConfig.propertySources.map(v => v.source);
    const sources = Object.assign({}, ...sourcesArray)
    global['SSO_APP_SECRET'] = sources['spring.application.secret']
    return sources
}

const getMysql = config === 'local' ? new Promise((resolve) => {
    const Mysql = MYSQL.createPool({
        'host': '127.0.0.1',
        'port': 3306,
        'user': 'wty',
        'password': 'wty990215',
        'database': 'dui123',
        'connectionLimit': 1000
    })
    resolve(Mysql)
}) : new Promise(async (resolve) => {
    const source = await getApollo()
    const username = source['apollo.mysql.duiba_web_tool.username']
    const password = source['apollo.mysql.duiba_web_tool.password']
    const database = source['apollo.mysql.duiba_web_tool.database']
    const host = source['apollo.mysql.duiba_web_tool.url'].split(':')[0]
    const port = source['apollo.mysql.duiba_web_tool.url'].split(':')[1]
    const Mysql = MYSQL.createPool({
        'host': host,
        'port': port,
        'user': username,
        'password': password,
        'database': database,
        'connectionLimit': 1000
    })
    // console.info('MysqlConfig:',Mysql.config)
    console.info('OBJMysql', Mysql)
    resolve(Mysql)
})


module.exports = getMysql





