import { sendTbNet, TbNetName } from "./TaoBaoNet";

// @ts-ignore
const app = getApp();

export default class TbFunc {

    /**
     * 赠送卡给好友
     * @param {{type: "invite", openId: string} | {type: "gift", cardId: string}} data
     * @return {Promise<void>}
     */
    static async showSharePanel(data: { type: "invite", openId: string, } | { type: "gift", cardId: string, cardType: 1 | 2 | 3 | 4 }) {
        await sendTbNet(TbNetName.showSharePanel, data);
    }

    /**
     * 打开入会插件
     * @return {Promise<void>}
     */
    static async openMember() {
        return await sendTbNet(TbNetName.openMember);
    }

    /**
     * 关注店铺
     * @return {Promise<void>}
     */
    static async favorShop() {
        return await sendTbNet(TbNetName.favorShop, null, null, true);
    }

    /**
     * 检查会员，要在app上挂checkMember方法
     * @return {Promise<boolean>}
     */
    static async checkMember() {
        // @ts-ignore
        return app.checkMember();
    }

    /**
     * 打开任务
     * @return {Promise<void>}
     */
    static async showTask() {
        await sendTbNet(TbNetName.openTask);
    }

    /**
     * 去我的奖品
     */
    static goMyPrize() {
        // @ts-ignore
        my && my.navigateTo({
            url: '/pages/myPrize/myPrize'
        });
    }

    /******************* 转接my方法 *******************/

    static navigateBack() {
        // @ts-ignore
        my && my.navigateBack();
    }

    static navigateTo(url) {
        // @ts-ignore
        my && my.navigateTo({ url });
    }

    static alert(title, content) {
        // @ts-ignore
        my && my.alert({
            title,
            content
        });
    }

    static navigateToOutside(url) {
        // @ts-ignore
        my && my.navigateToOutside({ url });
    }

    static saveImg(url: string) {
        //@ts-ignore
        if (my) {
            //@ts-ignore
            my.saveImage({
                url: url,
                showActionSheet: true,
                success: () => {
                    //@ts-ignore
                    my.alert({
                        title: '保存成功',
                    });
                },
            });
        }
    }


}
