import { RES } from "../../module/RES";
import { Scene } from "../../module/views/Scene";
import { LoadingEffect } from "../lotties/LoadingEffect";
import { changeScene } from "../../module/ctrls";
import UI from "../tools/UI";
import { getBoxConfig, M_loadGLB, typeArr } from "./Jump3D/MT";
import { PlayScene } from "./Jump3D/PlayScene";
import Lottie = FYGE.Lottie;
import Tween = FYGE.Tween;
import Event = FYGE.Event;


export class LoadingScene extends Scene {

	get groupNames(): string[] {
		return [
			'loading',
			'LoadingEffect',
		]
	}

	initUi() {

		UI.Sp(this, "com_bg.jpg");
		UI.Sp(this, "loading_title.png", 115, 356);

		const ani = this.addChild(new Lottie(LoadingEffect));
		ani.y = 710;
		ani.play();
	}

	async start() {
		super.start()

		this.addEventListener(Event.PROGRESS, this.progressEvent, this);

		const loadPromise = [];
		let pro = 0.0;
		for (let k of typeArr) {
			const config = getBoxConfig(k);
			loadPromise.push((async () => {
				await M_loadGLB(config.src);
				this.dispatchEvent(Event.PROGRESS, pro += 0.8 / typeArr.length);
			})());

			// await M_loadGLB(config.src);
			// this.dispatchEvent(Event.PROGRESS, pro += 0.8 / typeArr.length);
		}

		await Promise.all(loadPromise);
		this.dispatchEvent(Event.PROGRESS, 0.9);

		await RES.loadGroup("game");
		this.dispatchEvent(Event.PROGRESS, 1);

	}

	progressEvent(e: Event) {
		let pro = e.data;
		Tween.get({}, null, null, true)
			.to({ value: pro }, 0)
			.call(() => {
				if (pro >= 1) {
					this.removeEventListener(Event.PROGRESS, this.progressEvent, this);
					changeScene(PlayScene);
					// sendTbNet(TbNetName.openMusic, { isOn: true });
				}
			});
	}

	destroy() {
		//动效要去掉
		//  Tween.removeTweens()
		super.destroy()
		//到时如果内存炸了，考虑销毁用过的贴图缓存，待测试，在RES里写个根据销毁组内贴图的方法
	}
}
