import { Panel } from "../../module/views/Panel";
import UI from "../tools/UI";

export class RevivePanel extends Panel {
    get groupNames() {
        return ["RevivePanel"]
    }

    async initUi() {
	    UI.Sp(this, "reviveBg.png", 84, 474);

		UI.Btn(this, "reviveCancel.png", this.hidePanel, this, 131, 782);
		UI.Btn(this, "reviveOk.png", this.doRevive, this, 385, 778);
		UI.Btn(this, "comCloseBtn.png", this.hidePanel, this, 598, 369);
    }

    async doRevive(e) {
	    this.btnDelay(e.target);

	    this.data.revive();
	    super.hidePanel();
    }

    hidePanel() {
        super.hidePanel();
        this.data.submit();
    }

}
