/*
 * rollup.prod.mjs
 * Created by 还有醋v on 2022/5/24.
 * Copyright © 2021 haiyoucuv. All rights reserved.
 */

import json from "@rollup/plugin-json";
import resolve from "@rollup/plugin-node-resolve";
import typescript from "@rollup/plugin-typescript";
import fs from "fs";
import commonjs from "rollup-plugin-commonjs";
import glslLoader from "rollup-plugin-glsl-loader";
import progress from "rollup-plugin-progress";
import {terser} from "rollup-plugin-terser";
import BannerVariable from "./config/plugins/BannerVariable/index.mjs";
import babel from "@rollup/plugin-babel";

const {version} = JSON.parse(fs.readFileSync("./package.json", "utf-8"));

export default {
    input: "src/index.ts",
    output: [
        {
            file: "released/output.js",
            format: "umd",
            name: "output",
            sourcemap: true,
        },
        {
            file: 'released/output.module.js',
            format: 'esm',
            sourcemap: true,
        }
    ],
    plugins: [
        progress(),
        BannerVariable({
            values: {
                __ENV__: JSON.stringify(process.env.NODE_ENV || 'prod'),
                __version__: JSON.stringify(version),
                __buildDate__: JSON.stringify(new Date()),
            }
        }),
        babel.babel({
            exclude: "node_modules/**",
            presets: [
                [
                    "@babel/preset-env",
                    {
                        modules: false,
                        useBuiltIns: "usage",
                    }
                ]
            ],
            babelHelpers: "runtime"
        }),
        resolve({jsnext: true, preferBuiltins: true, browser: true}),
        commonjs(),
        typescript({sourceMap: true, watch: false,}),
        json(),
        glslLoader({
            glslify: true,
        }),

        terser(),
    ]
};
