/*
 * GamePage.jsx
 * Created by 还有醋v on 2022/6/6.
 * Copyright © 2022 haiyoucuv. All rights reserved.
 */


import React, { Component } from 'react';

import { Game } from "../../../debug/output.module";

import './GamePage.less';

export default class GamePage extends Component {
	
	div = null;
	game = null;
	
	constructor(props) {
		super(props);
		this.state = {};
	}
	
	componentDidMount() {
		const canvas = document.createElement("canvas");
		canvas.style = "width:100%;height:100%";
		this.div.appendChild(canvas);
		this.game = new Game(canvas);
		this.game.initWebEvent();
		
	}
	
	componentWillUnmount() {
		this.game.destroy()
	}
	
	render() {
		return <div
			className="game-page"
			ref={(div) => this.div = div}
		/>;
	}
}
