import { changeScene } from "../../module/ctrls";
import { Scene } from "../../module/views/Scene";
import { Tools } from "../tools/Tools";
import UI from "../tools/UI";
import { RES } from '../../module/RES';
import Button = FYGE.Button;
import Container = FYGE.Container;
import Shape = FYGE.Shape;
import Sprite = FYGE.Sprite;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import TextField = FYGE.TextField;
import VERTICAL_ALIGN = FYGE.VERTICAL_ALIGN;
import Texture = FYGE.Texture;
import FrameAni = FYGE.FrameAni;

export class SlideBg extends Container {

  bg1: Container = null

  bg2: Container = null

  /** 页面滑动速度 */
  speed = 10

  constructor() {
    super()
    this.init()
  }

  init() {
    Array(2).fill('').forEach((k, i) => {
      const bg:Container = this[`bg${i+1}`] = new Container()
      bg.addChild(new Sprite(RES.getRes('com_bg.jpg')))
      const base = new Sprite(RES.getRes('base.png'))
      bg.addChild(base)
      base.width = 750
      base.height = 250
      base.y = 1624 - base.height
      bg.x = i * 750
      this.addChild(bg)
    })
  }

  /** 帧动画 */
  enterFrame(rate) {
    [this.bg1, this.bg2].forEach((bg, i) => {
      bg.x -= this.speed * rate
      if(bg.x <= -750){
        bg.x += 750 * 2
      }
    })
  }

  destroy() {
    super.destroy();
  }

}