import { changeScene } from "../../module/ctrls";
import { Scene } from "../../module/views/Scene";
import { Tools } from "../tools/Tools";
import UI from "../tools/UI";
import { RES } from '../../module/RES';
import Button = FYGE.Button;
import Container = FYGE.Container;
import Shape = FYGE.Shape;
import Sprite = FYGE.Sprite;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import TextField = FYGE.TextField;
import VERTICAL_ALIGN = FYGE.VERTICAL_ALIGN;
import Texture = FYGE.Texture;
import FrameAni = FYGE.FrameAni;
import { Bird } from "./bird";
import { IndexScene } from "./IndexScene";

/**
 *  获取区间随机数 [min,max)
 * @export
 * @param {*} min
 * @param {*} max
 * @return {*} 
 */
function randomNum(min, max) {
  return Math.floor(Math.random() * (max - min)) + min
}

/**
 * 碰撞检测
 * @param {FYGE.Container} coA 
 * @param {FYGE.Container} coB 
 * @returns 是否碰撞
 */
export const isCollision = (coA, coB) => {
  const aGlobalPos = coA.localToGlobal(new FYGE.Point(0, 0), new FYGE.Point())
  const bGlobalPos = coB.localToGlobal(new FYGE.Point(0, 0), new FYGE.Point())

  const disX = (coA.width + coB.width) * 0.5
  const disY = (coB.height + coB.height) * 0.5

  const centerA = {
    x: aGlobalPos.x + coA.width * 0.5,
    y: aGlobalPos.y + coA.height * 0.5
  }

  const centerB = {
    x: bGlobalPos.x + coB.width * 0.5,
    y: bGlobalPos.y + coB.height * 0.5
  }

  const diffNumX = Math.abs(centerA.x - centerB.x)
  const diffNumY = Math.abs(centerA.y - centerB.y)

  return diffNumX < disX && diffNumY < disY
}

export class Pipe extends Container {

  /** 水管类型 */
  pipeType: 'up' | 'down' | any = ''

  constructor(type) {
    super()
    this.pipeType = type
    this.init()
  }

  init() {
    this.addChild(new Sprite(RES.getRes(this.pipeType === 'down' ? 'pipe_green_down.png' : 'pipe_green.png')))
    // this.scale.x = 2
    // this.scale.y = 5
  }

  destroy() {
    super.destroy();
  }

}

export class PipeMannager {
  /** 向上的水管回收池 */
  upPipes: Pipe[] = []

  /** 向下的水管回收池 */
  downPipes: Pipe[] = []

  /** 当前的水管池 */
  pipes: { up: Pipe, down: Pipe }[] = []

  /** 舞台 */
  stage: IndexScene = null

  /** 生成水管最小缺口 */
  minGap = 372

  /** 生成水管最大缺口 */
  maxGap = 432

  /** 水管移动速度 */
  speed = 3

  timer = null

  player: Bird = null

  deep = 0

  constructor(stage, player, deep) {
    this.stage = stage
    this.player = player
    this.deep = deep
    // this.createGroupPipe()
  }

  /** 开始游戏 */
  startGame() {
    this.timer = setTimeout(() => {
      this.createGroupPipe()
      this.startGame()
    }, 2000)
  }

  /** 创建一组水管 */
  createGroupPipe() {
    const upD = this.downPipes.length ? this.downPipes.pop() : new Pipe('down')
    const upP = this.upPipes.length ? this.upPipes.pop() : new Pipe('up')
    upD.x = 750
    upP.x = 750
    const randGap = randomNum(this.minGap, this.maxGap)

    const k = Math.random()
    upD.y = -812 - k * randGap
    upP.y = upP.height - 812 + (1 - k) * randGap
    this.stage.height
    this.pipes.push({
      up: upP,
      down: upD
    })
    this.stage.addChildAt(upD, this.deep - 1)
    this.stage.addChildAt(upP, this.deep - 1)
  }

  /** 帧动画 */
  enterFrame(rate) {
    for (let i = 0; i < this.pipes.length; i++) {
      if (!this.pipes[i]) continue
      const { up, down } = this.pipes[i]
      up.x -= this.speed * rate
      down.x -= this.speed * rate
      if (up.x <= -300 || down.x <= -400) {
        this.upPipes.push(up)
        this.stage.removeChild(up)
        this.downPipes.push(down)
        this.stage.removeChild(down)
        this.pipes[i] = null
      }
      const player = this.player
      const posx = player.x
      // 重叠水管
      if (((posx + player.width / 2) >= up.x) && ((posx - player.width / 2) <= (up.x + up.width))) {
        // console.log('水管中')
        const half =Number((player.height / 2).toFixed(3))
        // 碰撞头朝上的水管
        if (up.y <= (player.y + half)) {
          // console.log('触碰下',up.y,player.y, half)
          this.stage.gameOver()
        }
        // 碰撞头朝下的水管
        if ((down.y + down.height) >= (player.y - half)) {
          // console.log('触碰上',(down.y + down.height),(player.y - half))
          this.stage.gameOver()
        }
      }
    }
  }

  destroy() {
    clearTimeout(this.timer)
  }
}