import { changeScene } from "../../module/ctrls";
import { layers } from "../../module/views/layers";
import { Scene } from "../../module/views/Scene";
import { Tools } from "../tools/Tools";
import UI from "../tools/UI";
import { Bird } from "./bird";
import { PipeMannager } from "./pipe";
import { SlideBg } from "./slideBg";
import Button = FYGE.Button;
import Container = FYGE.Container;
import Shape = FYGE.Shape;
import Sprite = FYGE.Sprite;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import TextField = FYGE.TextField;
import VERTICAL_ALIGN = FYGE.VERTICAL_ALIGN;
import Texture = FYGE.Texture;
import FrameAni = FYGE.FrameAni

export class IndexScene extends Scene {

  get groupNames(): string[] {
    return [
      'index',
    ]
  }

  /** 玩家（鸟） */
  private bird: Bird = null

  /** 游戏是否结束 */
  private isGameOver: boolean = false

  /** 游戏是否开始 */
  private isGameStart: boolean = false

  /** 滑动背景 */
  private slideBg: SlideBg = null

  /** 水管管理器 */
  private pipeMannage: PipeMannager = null

  private prevTime = 0

  private rate = 1

  /** 分数实例 */
  private scoreText:TextField = null
  /** 得分 */
  private score = 0
  
  private timer = null

  async initUi() {
    // UI.Sp(this, Texture.from('com_bg.jpg'))
    this.slideBg = new SlideBg()

    this.addChild(this.slideBg)
    const bird = this.bird = new Bird()
    bird.x = 100
    bird.y = 800
    this.addChild(bird)
    this.scoreText = new TextField()
    this.addChild(this.scoreText)

    this.pipeMannage = new PipeMannager(this, bird,this.getChildIndex(this.scoreText))

    

    this.scoreText.text = `${this.score}`
    this.scoreText.size = 58
    this.scoreText.textAlign = TEXT_ALIGN.CENTER
    this.scoreText.fillColor = '#ff5432'
    this.scoreText.position.set((750-this.scoreText.width)/2, 200)

    this._initEvents()
  }

  _countDown(){
   this.timer = setTimeout(() => {
      this.score += 1
      this.scoreText.text = `${this.score}`
      this._countDown()
    }, 1000);
  }

  _initEvents() {
    this.addEventListener(FYGE.Event.ENTER_FRAME, this._enterFrame, this)
    this.addEventListener(FYGE.MouseEvent.CLICK, this.birdJump, this)
    // this.addEventListener(FYGE.MouseEvent.MOUSE_MOVE,this.testBird,this)
  }

  testBird(e) {
    this.bird.x = e.stageX
    this.bird.y = e.stageY
  }

  /** 检查小鸟掉落位置 */
  _checkRmove() {
    if (this.bird.y >= (this.stage.stageHeight)) {
      this.gameOver()
    }
  }

  /** 帧动画 */
  _enterFrame() {
    const now = Date.now()
    let rate = 1
    if (this.prevTime) {
      const dt = now - this.prevTime
      this.rate = rate = dt / 16.7
    }
    this.prevTime = now

    if (this.isGameOver) return
    this.slideBg.enterFrame(rate)
    this.pipeMannage.enterFrame(rate)
    if (!this.isGameStart) return
    this.bird.fail(rate)
    this._checkRmove()
  }

  /** 游戏结束 */
  gameOver() {
    this.isGameOver = true
    this.isGameStart = false
    this.bird.gameOver()
    this.pipeMannage.destroy()
    clearTimeout(this.timer)
    window.alert('GameOver\n得分：'+this.score)
  }

  /** 小鸟跳跃 */
  birdJump() {
    if(this.isGameOver) {
      window.location.reload()
    }
    if (!this.isGameStart) {
      this.startGame()
      return
    }
    this.bird.jump(this.rate)
  }

  /** 开始游戏 */
  startGame() {
    this._countDown()
    if (this.isGameOver) {
      this.bird.y = 500
      this.bird.reset()
    }
    this.isGameStart = true
    this.isGameOver = false
    this.pipeMannage.startGame()
  }

  destroy() {
    this.pipeMannage.destroy()
    super.destroy();
  }

}