import { changeScene } from "../../module/ctrls";
import { Panel } from "../../module/views/Panel";
import { IndexScene } from "../scenes/IndexScene";
// import { LoadingScene } from "../scenes/LoadingScene";
import UI from "../tools/UI";
import Sprite = FYGE.Sprite;

export class OverPrizePanel extends Panel {
    get groupNames() {
        return ["OverPanel"]
    }

    async initUi() {

		UI.Sp(this, "overPrizeBg.png", 84, 309);

	    UI.Btn(this, "overBtn.png", this.again, this, 167, 979);

	    UI.Txt(
		    this, this.data.score + "", 60, '#704a5b',
		    FYGE.TEXT_ALIGN.CENTER, 750, 0, 593
	    );

	    UI.Txt(
		    this, "请前往「我的奖品」页领取", 24, '#a35e7a',
		    FYGE.TEXT_ALIGN.CENTER, 750, 0, 924
	    );

	    const img = this.addChild(Sprite.fromUrl(this.data.prizeInfo.image));
	    img.anchorTexture.set(0.5, 0.5);
	    img.position.set(375, 790);
	    img.width = img.height = 214;

	    UI.Btn(this, "comCloseBtn.png", this.hidePanel, this, 598, 369);

    }

    // 再来一次
    async again(e) {
	    this.btnDelay(e.target);
	    super.hidePanel();
	    // changeScene(LoadingScene);
    }

    hidePanel() {
        super.hidePanel();
        changeScene(IndexScene);
    }

}
