/*
 * usePool.ts
 * Created by 还有醋v on 2022/6/1.
 * Copyright © 2022 haiyoucuv. All rights reserved.
 */

/**
 * 使用对象池能力
 * @param cls
 */
export function usePool<T extends {new (...args: any[]): any}>(cls: T) {
	return class nCls extends cls {

		static _pool: T[] = [];

		static get(): T {
			return this._pool.splice(0, 1)[0] || new nCls();
		}

		static put(obj: T) {
			return this._pool.push(obj);
		}

	};
}
