/** 关卡信息 */
export const LevelInfo = [
  { level: 1, colors: ['#EC5F33', '#E52800', '#CA1D00'] }
  { level: 2, colors: ['#FF9400', '#FF6C00', '#EC5F33', '#E52800', '#CA1D00'] }
  { level: 3, colors: ['#FFD34A', '#FFC300', '#FFB637', '#FF9400', '#FF6C00', '#EC5F33', '#E52800', '#CA1D00'] }
]

export const CUSTOM_EVENT = {
  /** 爪子动画结束的回调 */
  CLIP_ANI_END: 'CLIP_ANI_END',
  /** 爪子碰撞 */
  CLIP_COLLISION: 'CLIP_COLLISION',
  /** 游戏结束 */
  GAME_OVER: 'GAME_OVER',
  /** 下一关 */
  NEXT_LEVEL: 'NEXT_LEVEL',
  /** 过关 */
  PASS_LEVEL: 'PASS_LEVEL',
  /** 开始游戏 */
  GAME_START: 'GAME_START'
}

export const Config = {
  /**  爪子能伸出去的长度 */
  maxLong: 644,

  /** 摇晃速度 */
  rotationSpeed: 1,

  /** 爪子伸出去的速度 */
  playSpeed: 350,

  /** 普通道具移动速度 */
  normalPropSpeed: 250,

  /** 高级道具移动速度 */
  bestPropSpeed: 500,

  /** 每轮生成加分道具数量 */
  bestPropsNum: 3,

  /** 普通道具每种最多生成数量 */
  propsNum: 2,

  /** 每关的游戏时间 */
  countDowns: [30, 30, 30]

  /** 道具分布图 4*3 */
  propsMap: [
    [
      1, 0, 0, 1,
      1, 1, 1, 0,
      1, 1, 1, 1
    ],
    [
      1, 0, 0, 1,
      1, 1, 1, 1,
      1, 0, 1, 1
    ]
  ]
}