// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

import { CUSTOM_EVENT } from "./Config/GameConfig";

const { ccclass, property } = cc._decorator;

@ccclass
export default class ClipAni extends cc.Component {
  eventAniEnd: cc.Event.EventCustom = null
  eventCollEnt:cc.Event.EventCustom = null

  start() {
    this.eventAniEnd = new cc.Event.EventCustom(CUSTOM_EVENT.CLIP_ANI_END, true)
    this.eventCollEnt = new cc.Event.EventCustom(CUSTOM_EVENT.CLIP_COLLISION, true)
  }

  /** 碰撞事件 */
  onCollisionEnter(other: cc.Collider, self: cc.Collider) {
    this.eventCollEnt.detail = {
      other
    }
    cc.find('Canvas').dispatchEvent(this.eventCollEnt)
  }

  onAnimCompleted(state) {
    this.eventAniEnd.detail = {
      state
    }
    cc.find('Canvas').dispatchEvent(this.eventAniEnd)
  }

}
