/**
 * 十六进制颜色转rgb
 * @param str 
 * @returns 
 */
export const set16ToRgb = (str) => {
  if (!str) return
  var reg = /^#([0-9A-Fa-f]{3}|[0-9A-Fa-f]{6})$/
  if (!reg.test(str)) { return; }
  let newStr = (str.toLowerCase()).replace(/\#/g, '')
  let len = newStr.length;
  if (len == 3) {
    let t = ''
    for (var i = 0; i < len; i++) {
      t += newStr.slice(i, i + 1).concat(newStr.slice(i, i + 1))
    }
    newStr = t
  }
  let arr = []; //将字符串分隔，两个两个的分隔
  for (var i = 0; i < 6; i = i + 2) {
    let s = newStr.slice(i, i + 2)
    arr.push(parseInt("0x" + s))
  }
  return arr;
}

/**
 * 数字转换为汉字（0-10）
 * @param num 0-10
 * @returns 
 */
export const numToChinese = (num) => {
  const numMap = ['零', '一', '二', '三', '四', '五', '六', '七', '八', '九', '十']
  return numMap[num]
}
/** 加载游戏资源 */
export const loadGameResources = async () => {
  return new Promise((resolve, reject) => {
    cc.resources.preloadDir('images', cc.SpriteFrame, (err, res) => {
      console.log('111',res)
      resolve(res,err)
    })
  })
}

