export const CUSTOM_EVENT = {
  /** 爪子动画结束的回调 */
  CLIP_ANI_END: 'CLIP_ANI_END',
  /** 爪子碰撞 */
  CLIP_COLLISION: 'CLIP_COLLISION',
  /** 游戏结束 */
  GAME_OVER: 'GAME_OVER',
  /** 下一关 */
  NEXT_LEVEL: 'NEXT_LEVEL',
  /** 过关 */
  PASS_LEVEL: 'PASS_LEVEL',
  /** 开始游戏 */
  GAME_START: 'GAME_START',
  /** 初始化游戏数据 */
  GAME_INIT: 'GAME_INIT',
  /** 销毁游戏场景 */
  GAME_DESTROY: 'GAME_DESTROY'
}
/** 游戏进度颜色 */
export const GameColors = [
  ['#EC5F33', '#E52800', '#CA1D00'],
  ['#FF9400', '#FF6C00', '#EC5F33', '#E52800', '#CA1D00'],
  ['#FFD34A', '#FFC300', '#FFB637', '#FF9400', '#FF6C00', '#EC5F33', '#E52800', '#CA1D00']
]

export const Config = {
  /**  爪子能伸出去的长度 */
  maxLong: 644,

  /** 摇晃速度 */
  rotationSpeed: 1,

  /** 爪子伸出去的速度 */
  playSpeed: 350,

  /** 普通道具移动速度 */
  normalPropSpeed: 250,

  /** 高级道具移动速度 */
  bestPropSpeed: 500,

  /** 每轮生成加分道具数量 */
  bestPropsNum: 3,

  /** 普通道具每种最多生成数量 */
  propsNum: 2,

  /** 每关的游戏时间 */
  countDowns: [30, 30, 30],

  /** 关卡信息 */
  LevelInfo: [
    {
      level: 1,
      /** 目标数量 */
      num: 10,
      /** 倒计时 */
      cds: 30,
    },
    {
      level: 1,
      /** 目标数量 */
      num: 5,
      /** 倒计时 */
      cds: 30,
    },
    {
      level: 1,
      /** 目标数量 */
      num: 8,
      /** 倒计时 */
      cds: 30,
    }
  ],

  /** 进度默认颜色 */
  defaultColor: "#FF6C00",

  /** 道具分布图 4*3 */
  propsMap: [
    [
      1, 0, 0, 1,
      1, 1, 1, 0,
      1, 1, 1, 1
    ],
    [
      1, 0, 0, 1,
      1, 1, 1, 1,
      1, 0, 1, 1
    ]
  ]
}