// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

import Svga from "./Components/Svga/Svga";
import { SvgaEvent } from "./Components/Svga/SvgaEvent";
import { CUSTOM_EVENT, Config, GameColors } from "./Config/GameConfig";
import exportEvent from "./exportEvent";
import { getProbability, getRandomArrayElements, loadGameResources, numToChinese, randomNum, getUrlParam } from "./utils";
const { ccclass, property } = cc._decorator;

// 爪子状态
const CLIP_STATE = {
  /** 默认 */
  DEFAULT: 'clipAni',
  /** 出钩 */
  PLAY: 'clipPlay',
  /** 收回 */
  STOP: 'clipStop',
  /** 游戏结束 */
  GAME_OVER: 'gameOver'
}

@ccclass
export default class GameScene extends cc.Component {
  /** 游戏配置 */
  gameConfig = { ...Config }
  /** 游戏是否结束 */
  isGameOver = false
  /** 游戏是否开始 */
  isStartGame = false
  /** 切屏倒计时 */
  dateNow = 0
  /** 游戏倒计时 */
  countDown = 10

  protected onLoad(): void {

    // loadGameResources()
    /** 开启碰撞检测 */
    const cm = cc.director.getCollisionManager()
    cm.enabled = true
    // cm.enabledDebugDraw = true;
  }

  start() {
    this.addNodeEvent()
  }

  /** 添加节点的事件 */
  addNodeEvent() {

    cc.game.on(cc.game.EVENT_HIDE, () => {
      this.dateNow = Date.now()
    })
    cc.game.on(cc.game.EVENT_SHOW, () => {
      const difference = Date.now() - this.dateNow
      this.countDown = Math.max(0, this.countDown - Math.ceil(difference / 1000))
      this.dateNow = 0
    })

    exportEvent.on(CUSTOM_EVENT.GAME_START, this.startGame, this)
    exportEvent.on(CUSTOM_EVENT.GAME_INIT, ({ detail = {} }) => {
      this.resetConfig(detail)
    }, this)
    exportEvent.on(CUSTOM_EVENT.GAME_DESTROY, () => {
      this.node.destroy()
    }, this)
    // TODO 测试用
    const href = window?.location?.href
    const isTest = getUrlParam('testPanel')
    const testNode = cc.find('test', this.node)
    testNode.active = isTest
    if (isTest && (href?.includes('duibadev') || href?.includes('duibatest')) || href.includes('localhost')) {
      const testEventMap = {
        start: 'testStartGame',
        init: 'testInit',
        addSpeed: 'addSpeeds'
      }
      testNode.children.forEach((n) => {
        const event = this?.[testEventMap[n.name]]
        n.on(cc.Node.EventType.TOUCH_END, event, this)
      })
    }
  }

  testStartGame() {
    console.log('测试')
    exportEvent.fire(CUSTOM_EVENT.GAME_START)
  }

  testInit() {
    console.log('测试初始化')
    exportEvent.fire(CUSTOM_EVENT.GAME_INIT, {
    })
  }

  /**
   * 开始游戏
   * @param config config
   */
  startGame({ detail = {} }) {
    console.log('start')
    this.schedule(this.startCd,1)
  }

  /**
   * 重置游戏配置
   * @param con 游戏配置
   */
  resetConfig(con = {}) {
    this.gameConfig = {
      ...Config,
      ...con
    }
  }

  /** 爪子碰撞事件 */
  onCollEnter({ detail }) {
  }

  /** 游戏结束 */
  gameOver() {
    this.isGameOver = true
    this.unschedule(this.startCd)
    exportEvent.fire(CUSTOM_EVENT.GAME_OVER, {
      ...this.gameConfig.LevelInfo[this.actLevel],
      score: this.starNum,
      level: this.actLevel
    })
  }

  /**
   * 设置节点lable
   * @param value 
   */
  setLable(key, value) {
    cc.find(key, this.node).getComponent(cc.Label).string = value + ''
  }

  /** 开始倒计时 */
  startCd() {
    const cd = this.countDown - 1 || 0
    if (!cd || cd <= 0) {
      this.setLable('cdIcon/cd', `0s`)
      this.gameOver()
      this.unschedule(this.startCd)
      return
    }
    this.countDown = cd
    this.setLable('cdIcon/cd', `${this.countDown}s`)
  }

  protected onDestroy(): void {
    this.unschedule(this.startCd)
  }

  /** 刷新关卡信息 */
  refreshLevelInfo(level = 0) {
    this.isGameOver = false
  }

  update(dt: number): void {
    if (this.isGameOver || !this.isStartGame) return

  }
}
